/***********************************************************************/
/** @name global.c   
    Contains global definitions and variables.
    
    @author Thomas Braunl & Birgit Graf, UWA, 1998
*/
/***********************************************************************/

/*@{*/

#include "global.h"

meterPerSec  LIN_SPEED = 0.35;
radPerSec ROT_SPEED = 0.7;

/** ball distance in meters depending on x and y position in pixels */
float ball_dist[3][imagerows / 2][imagecolumns];

/** Handle for motors */
VWHandle vw;

/** flag whether motors are used or test mode without motors */
int use_motors;		
  
/** flag to indicate current camera position (UP or DOWN), set after
    camera movement */
int cam_pos;  


/* ----= flags to indicate results of sensor readings  =---- */
/** flag to indicate keypress (-> end ball search) */
int end_flag = FALSE;

/** flag to indicate detected object */
int obstacle_flag = FALSE;

/** flag to indicate having ball caught in front of robot */
int got_ball_flag = FALSE;

/** flag to indicate seeing ball */
int see_ball_flag = FALSE;

/** flag to indicate that program just started */
int start_flag = TRUE;
int start_flag1 = TRUE;
int attack_flag = FALSE;

/** flag for competition mode */
int competition_mode;		
  
/** position of player */
int player_pos = 0;

/** home position of different players */ 
PositionType home[4][3] =
{{{LENGTH4, 0.2, 0.0},        {LENGTH2 - 0.3, WIDTH2 - 0.3, 0.0},  {0.3, WIDTH2 - 0.3, 0.0}},             /* lb */
 {{LENGTH4, -0.2, 0.0},       {LENGTH2 - 0.3, -WIDTH2 + 0.3, 0.0}, {0.3, -WIDTH2 + 0.3, 0.0}},            /* rb */
 {{3.0 * LENGTH4, 0.2, 0.0},  {LENGTH - 0.3, WIDTH2 - 0.3, 0.0},   {LENGTH2 + 0.3, WIDTH2 - 0.3, 0.0}},   /* lf */
 {{3.0 * LENGTH4, -0.2, 0.0}, {LENGTH - 0.3, -WIDTH2 + 0.3, 0.0},  {LENGTH2 + 0.3, -WIDTH2 + 0.3, 0.0}}}; /* rf */

/** next home position */
int next_home = 0;

/** flags and global variables I have added */

role MyRole;

/** have  I been told where the ball is? */
int told_where_flag=0;

/** where we where told the ball is */
PositionType ToldPos;

/** reset to start postion and wait for start */
int reset_flag=0;

/** I just had the ball, now it's gone */
int just_lost_flag=FALSE;

/** Need to check for a wall */
int check_wall_flag=FALSE;


/** Another teammate has the ball */
int teammate_has_ball=0;

/** Where to go on a reset */
PositionType reset_pos;

/** Whether we're waiting for play to start, or are playing */
int play_flag;


/** Ball direction info for tracking purposes */
float BallDeltaX, BallDeltaY;

/** Ball position in image */
image_position BallImagePos;

/** Flag to indicate when the obstacle is a wall */
int is_wall_flag = FALSE;

/** Flag to say when to find x,y position */
int find_loc_flag = FALSE;
int found_wall_flag = FALSE;

/** Flags to for goal search */
int look_for_goal_flag = FALSE;
int found_goal_flag = 0; /* 0 = not looked yet */
/* 1 = looked, not found */
/* 2 = looked, found */

/*@}*/

