/** @name cam.c 

    Display camera picture until end-button is pressed. If camera is
    colour camera, picture is converted to greyscale picture.
    Menu-output: gEnd for greyscale, cEnd for colour camera.

    @author Birgit Graf,   UWA, 1998
    @author Thomas Braunl, UWA, 2000
    @version 1.0
*/

#include "eyebot.h"
colimage colimg;  /* picture to work on */
image    greyimg; /* picture for LCD-output */
int      camera;  /* camera version */

/** print error message and exit */
void error(char *str)
{
  LCDPrintf("ERROR: %s\n",str);
  OSWait(200);
  exit(0);
}

/** main program. Display camera picture until end-button is pressed. */
void main()
{ camera=CAMInit(NORMAL);
  if (camera==NOCAM) error("No camera!\n");
    else if (camera==INITERROR) error("CAMInit!\n");
  LCDMenu("","","","End");

  while (KEYRead()!=KEY4)
  { if (camera<COLCAM)
    { CAMGetFrame(&greyimg); 
      LCDPutGraphic(&greyimg);  
    }
    else
    { CAMGetColFrame(&colimg,FALSE); 
      LCDPutColorGraphic(&colimg);
    }
  }
}

