/* ***************************************************************
Thomas Braunl, 22.05.98, UWA

moving the biped walked
- easy gymnastics -
*************************************************************** */

#include "librobi/librobi.h"
#include "libimpro/improc.h"
#include "librobi/protos.h"

#include "keys.h"
#include "lcd.h"
#include "cam.h"
#include "types.h" 
#include "kern.h"
#include "rs232.h"
#include "hdt.h"
#include "hdt_sem.h"

#include <math.h>
#include <stdio.h>
#include <unistd.h>


ServoHandle serv[9];


/************* MAIN ***************** */
int main ()
{ int i,angle, speed;
  char k;
  typedef enum{ rHipT,rHipB,rKnee,rAnkle,torso,lAnkle,lKnee,lHipB,lHipT} link;
  int   up[9] =  {127, 127, 127, 127,     127,    127, 127, 127, 127};
  int down[9] =  {127,  80, 200,  80,     127,    200,  80, 200, 127}; /* example */

  /* initialization */
  setvbuf	(stdout,NULL,_IONBF,0);	
  setvbuf	(stdin,NULL,_IONBF,0);	
  LCDMode(SCROLLING|NOCURSOR);
  printf("Here is Johnny..\n");

  /* get parameters */
  LCDMenu("+","-"," ","CON");
  angle = 60;
/*  do
  { printf("angle %3d\n", angle);
    k = KEYGet();
    if (k == KEY1) angle += 10;
    if (k == KEY2) angle -= 10;
  } while (k != KEY4);
*/

  speed = 2;
  do
  { printf("speed %3d\n", speed);
    k = KEYGet();
    if (k == KEY1) speed += 1;
    if (k == KEY2) speed -= 1;
    if (speed < 1) speed = 10;
    if (speed > 9) speed =  1;
  } while (k != KEY4);


  /* set positions */
  down[rHipB] = 127 - angle;  down[rKnee] = 127 + 2*angle;  down[rAnkle] = 127 + angle;
  down[lHipB] = 127 + angle;  down[lKnee] = 127 - 2*angle;  down[lAnkle] = 127 - angle;
  down[rHipT] = 127;          down[torso] = 127;            down[lHipT]  = 127;


  /* allocate handels for all servos */
  serv[0]=SERVOInit(RHipT);  serv[1]=SERVOInit(RHipB);  
  serv[2]=SERVOInit(RKnee);  serv[3]=SERVOInit(RAnkle);  
  serv[4]=SERVOInit(Torso);  
  serv[5]=SERVOInit(LAnkle); serv[6]=SERVOInit(LKnee);  
  serv[7]=SERVOInit(LHipB);  serv[8]=SERVOInit(LHipT);  


  /* middle position */
  printf("Servos mid-pos..\n");
  for(i=0;i<9;i++) SERVOSet(serv[i],up[i]);

  LCDMenu("GO"," "," ","END");
  k = KEYWait(KEY1);

  while (k != KEY4)
  {
    move(up,down, speed);
    move(down,up, speed);
    k = KEYRead();
  }
}


int move(int old[], int new[], int speed)
{ int i,j;
  int steps = 100;
  float now[9], diff[9];

  for (j=0; j<9; j++)
  { now[j]  = (float) old[j];
    diff[j] = (float) (new[j] - old[j]) / (float) steps;
    printf("%4.1f ", diff[j]);
  }

  for (i=0; i<steps; i++)
  {
    for (j=0; j<9; j++)
    { now[j] +=  diff[j];
      SERVOSet(serv[j], (int) now[j]);
    }
    OSWait(speed);
  }

  SERVORelease(RHipT);  SERVORelease(RHipB);  
  SERVORelease(RKnee);  SERVORelease(RAnkle);  
  SERVORelease(Torso);  
  SERVORelease(LAnkle); SERVORelease(LKnee);  
  SERVORelease(LHipB);  SERVORelease(LHipT);  
}

