/** @name ping.c
  * Tests sending and receiving via wireless transmission
  * VERSION FOR EYEBOT
  * @author Thomas Braunl, Nov. 2000
  */

#include "eyebot.h"

int main()
{ BYTE myId, nextId, fromId;
  BYTE mes[20]; /* message buffer */
  int  len, err;

  LCDPutString("Wireless Eye2PC\n");
  LCDPutString("---------------\n");
  LCDMenu(" "," "," ","END");

  myId = OSMachineID();
  if (myId==0) { LCDPutString("RadioLib not enabled!\n"); return 1; }
    else LCDPrintf("I am robot %d\n", myId);
  switch(myId)
  { case 1 : nextId = 0; break;
    default: LCDPutString("Set ID to 1\n"); return 1;
  }

  LCDPutString("Radio");
  err = RADIOInit();
  if (err) { LCDPutString("Error Radio Init\n"); return 1; }
    else LCDPutString("Init\n");

  if (myId == 1)  /* robot 1 gets first to send */
  { mes[0] = 0;
    err = RADIOSend(nextId, 1, mes);
    if (err) { LCDPutString("Error Send\n"); return 1; }
  }

  while ((KEYRead()) != KEY4)
  { if (RADIOCheck())  /* check whether message is waiting */
    { RADIORecv(&fromId, &len, mes);  /* wait for next message */
      LCDPrintf("Recv %d-%d: %3d\a\n", fromId, len, mes[0]);
      mes[0]++;              /* increment number and send again */
      err = RADIOSend(nextId, 1, mes);
      if (err) { LCDPutString("Error Send\n"); return 1; }
    }
  }
  RADIOTerm();
  return 0;
}

