#ifndef _KERN_H_
#define _KERN_H_

#include "reg.h"

#define	COOP	0		/* operation mode */
#define PREEMPT	1
#define NOTASK  255
#define	DEFAULT	COOP

#define IDLE_STACKSIZE      128		/* stack sizes */
#define DEFAULT_STACKSIZE   4096
#define SMALL_STACKSIZE     2048

#define MAX_PRI 8               /* MAX and MIN pri allowed for user programs */
#define MIN_PRI 1
#define IDLE_PRI 0              /* this pri is reserved for the system  */

struct tcb {                    /* Thread control block */
	struct tcb *next;       /* double linked ring list pointers */
	struct tcb *prev;
	struct tcb *semq;       /* semaphore ist pointer    */
	struct pstat pstat;     /* processor status save location   */
	int stkbeg;             /* stack data   */
	int stkend;
	int stksiz;
	char *stackbase;
	int pri;                /* thread priority  */
	int stat;               /* thread status    */
	char *name;             /* thread name      */
	int uid;                /* UserID           */
};

#define TASK_NEW        0       /* the stati a thread can have  */
#define TASK_READY      1
#define TASK_SUSPEND    2

struct tcbq {                   /* thread control block queue anchor */
	struct tcb *next;
	int     pristat;        /* static priority value    */
	int     pridyn;         /* dynamic priority value   */
	int     threads;        /* not used yet             */
};

#define STACK_FENCE_SIZE        16  /* 16 bytes fences around the stack */

struct sem {                    /* semaphore structure  */
	struct tcbq waitq;      /* list of threads      */
	int count;              /* counter              */
};

#endif
