/*
| -----------------------------------------------------------------------------
| Filename: hdttest.c
|
| Author:       Thomas Braunl   (braunl@ee.uwa.edu.au)
|               Klaus Schmitt   (kschmitt@informatik.uni-kl.de)
| Description: 
| -------
| HDT data for EyeBot MK4, UWA Aug. 2000
| -----------------------------------------------------------------------------
*/

#define VERSION 1.1      /* User specific version nr. for information */
#define NAME "Eye-MK4"   /* controller name max. 7 chars, inform. only */
#define ID   3           /* Unique platform id (int), just for inform. */

#include "hdt.h"
#include "hdt_sem.h"

/* The HDT structure */
/*-------------------*/
int     magic = 123456789;
extern HDT_entry_type HDT[];
HDT_entry_type  *hdtbase = &HDT[0];

#include "types.h"
#include "const.h"
#include "rs232.h"
#include "cam.h"
#include "librobi/librobi.h"

short dist0[128] = { 60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  60,
                     60,  60,  60,  60,  60,  60,  60,  60,  60,  60,  65,  69,  70,  73,  75,
                     76,  77,  79,  81,  84,  85,  87,  88,  89,  90,  93,  95,  96,  98, 100,
                    103, 105, 107, 109, 110, 112, 114, 116, 117, 119, 121, 126, 127, 129, 131,
                    134, 137, 140, 144, 146, 149, 151, 156, 159, 167, 170, 175, 179, 183, 188,
                    195, 200, 205, 210, 220, 225, 235, 240, 250, 265, 275, 285, 295, 310, 320,
                    340, 350, 370, 380, 400, 410, 440, 460, 490, 530, 600, 610, 630, 680, 750,
                    830, 900, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999, 999,
                    999, 999, 999, 999, 999, 999, 999, 999};

BYTE motconv0[101]= { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15,16,17,18,19,
                     20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,
                     40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,
                     60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,
                     80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,
                     100};

/* DC motors */
/* Motor A = left, Motor B = right */
motor_type motorA = {2, 0, TIMER1, 8191, (void*)sim_porte, 0, 1, (BYTE*)0};
motor_type motorB = {2, 1, TIMER1, 8191, (void*)sim_porte, 3, 2, (BYTE*)0};
quad_type  encoderA = {0, 2, 3, MOTOR_LEFT,  3240, 2.0};
quad_type  encoderB = {0, 5, 4, MOTOR_RIGHT, 3240, 2.0};
vw_type drive = {0, DIFFERENTIAL_DRIVE, {QUAD_LEFT, QUAD_RIGHT, 0.085}};


/* SERVOs */
/* type, TPU-channel, Timer2, 20ms period, 0.7ms min, 1.7ms max */
/* here: servo 1 has TPU channel 2, and so on                   */
servo_type servo1  = {2,  2, TIMER2, 20000, 700, 1700};
servo_type servo2  = {2,  3, TIMER2, 20000, 700, 1700};
servo_type servo3  = {2,  4, TIMER2, 20000, 700, 1700};
servo_type servo4  = {2,  5, TIMER2, 20000, 700, 1700};
servo_type servo5  = {2,  6, TIMER2, 20000, 700, 1700};
servo_type servo6  = {2,  7, TIMER2, 20000, 700, 1700};
servo_type servo7  = {2,  8, TIMER2, 20000, 700, 1700};
servo_type servo8  = {2,  9, TIMER2, 20000, 700, 1700};
servo_type servo9  = {2, 10, TIMER2, 20000, 700, 1700};
servo_type servo10 = {2, 11, TIMER2, 20000, 700, 1700};
servo_type servo11 = {2, 12, TIMER2, 20000, 700, 1700};
servo_type servo12 = {2, 13, TIMER2, 20000, 700, 1700};


/* PSD-infrared */
psd_type   psd0   = {0, 14, (BYTE*)IOBase, 0, AH, (BYTE*)IOBase, 0, AH,
(short*)&dist0};
psd_type   psd1   = {0, 14, (BYTE*)IOBase, 1, AH, (BYTE*)IOBase, 0, AH,
(short*)&dist0};
psd_type   psd2   = {0, 14, (BYTE*)IOBase, 2, AH, (BYTE*)IOBase, 0, AH,
(short*)&dist0};
psd_type   psd3   = {0, 14, (BYTE*)IOBase, 3, AH, (BYTE*)IOBase, 0, AH,
(short*)&dist0};
psd_type   psd4   = {0, 14, (BYTE*)sim_porte, 5, AH, (BYTE*)IOBase, 0,
AH, (short*)&dist0};
psd_type   psd5   = {0, 14, (BYTE*)sim_porte, 4, AH, (BYTE*)IOBase, 0,
AH, (short*)&dist0};

compass_type compass = {0,13,(void*)IOBase, 2,(void*)IOBase, 4, (BYTE*)IOBase, 0};


/* EyeBot SUMMARY */
info_type roboinfo  = {0,VEHICLE,SER115200,RTSCTS,SERIAL1,0,0,AUTOBRIGHTNESS,BATTERY_ON,35,VERSION,NAME,ID};

/* waitstates = 0..13, Fast Termination = 14, External = 15 */
/* Version, ROM, RAM, LCD, IO, Parallel+Serial2/3 */
/* 16MHz - 20Mhz */
/* waitstate_type waitstates = {0,3,0,1,0,2}; */
/* 21MHz - 41Mhz */
waitstate_type waitstates = {0,3,1,2,1,2};

/* this is a test HDT structure which contains ALL EyeBot hardware devices */

int startmelody[] = {1114,200, 2173,200, 1114,200, 1487,200, 1669,320, 0};

image_type startimage = {0x00,0x00,                                                           
0x00,0x00,0xB7,0x70,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x17,0xFF,0xFF,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x01,0x7F,0xFF,0xFF,0x87,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x17,0x3F,0x7F,0xB9,0xFF,0xFF,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xFC,0xFD,0xBC,0xDF,0xFF,0xD7,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,
0xE9,0xDB,0x37,0x6C,0xCF,0x3F,0x8F,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,
0xD3,0xE4,0xC0,0xB2,0x13,0x8F,0xF8,0x0F,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,
0xA7,0x8B,0x03,0x4C,0x6C,0x70,0x7F,0xFD,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,
0x03,0x00,0x00,0x00,0x01,0x87,0xFF,0xFF,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x50,
0x84,0x00,0x00,0x00,0x00,0x17,0xCF,0x81,0xFC,0x00,0x00,0x00,0x00,0x00,0x01,0xED,
0x00,0x00,0x00,0x00,0x00,0x30,0x39,0xF8,0xFE,0x00,0x00,0x00,0x00,0x00,0x01,0xC0,
0x00,0x00,0x00,0x00,0x00,0x01,0xCF,0xDF,0xFF,0xE0,0x00,0x00,0x00,0x00,0x07,0x80,
0x00,0x00,0x00,0x00,0x30,0x07,0xFB,0xE0,0x03,0xFC,0x80,0x00,0x00,0x00,0x0E,0x00,
0x00,0xFC,0x00,0x00,0x50,0x01,0x80,0x3F,0xFF,0x07,0x82,0x00,0x00,0x00,0x0C,0x00,
0x01,0xFC,0x00,0x00,0xA0,0x0C,0x00,0x01,0xFF,0xFF,0x8E,0x00,0x00,0x00,0x38,0x00,
0x0F,0xFC,0x00,0x01,0x20,0x1C,0x00,0x07,0xFF,0xF0,0x7D,0x00,0x00,0x00,0x40,0x00,
0x1F,0xB0,0x00,0x02,0x40,0x7C,0x00,0x00,0x3F,0xFC,0x0C,0x36,0x60,0x00,0x00,0x00,
0x3E,0x20,0x00,0x06,0x86,0x78,0x00,0x00,0x3F,0xEF,0xE1,0xDF,0xC0,0x00,0x00,0x00,
0x38,0x00,0x00,0x05,0x0F,0xA0,0x00,0x00,0x01,0xFF,0xFF,0xFB,0x06,0x00,0x00,0x00,
0x70,0x00,0x00,0x7A,0x5B,0x60,0x00,0x00,0x01,0xFF,0xFC,0xDC,0x39,0x00,0x00,0x00,
0x60,0x30,0x88,0xBC,0xDB,0x40,0x00,0x00,0x00,0x1F,0xFF,0xF8,0xE7,0x40,0x00,0x00,
0x1F,0xE1,0x9B,0x69,0xF7,0xC8,0x00,0x00,0x00,0x07,0xFE,0x7F,0xFE,0xC8,0x00,0x00,
0x01,0xC3,0x34,0x99,0xA6,0xF0,0x00,0x00,0x00,0x00,0x7E,0xFF,0xFF,0xF4,0x00,0x00,
0x0E,0x07,0x67,0x11,0xE7,0xE0,0x00,0x00,0x00,0x00,0x0F,0xDF,0x7D,0xAA,0x00,0x00,
0x18,0x06,0x6F,0x3F,0x38,0xC0,0x00,0x00,0x00,0x00,0x01,0xFF,0x7E,0x98,0x00,0x00,
0x70,0x35,0xBF,0xCC,0x10,0x00,0x00,0x00,0x00,0x00,0x0E,0x7F,0xFB,0x40,0x00,0x00,
0xC0,0x67,0x47,0x80,0x00,0x00,0x7F,0x80,0x00,0x00,0x00,0x17,0xDC,0x00,0x00,0x21,
0x81,0xC6,0xA0,0x00,0x00,0x00,0x00,0x07,0xC0,0x00,0x00,0x1F,0xC0,0x00,0x00,0x01,
0x87,0xC0,0xC0,0x00,0x02,0x00,0x00,0x00,0x1C,0x00,0x07,0xF7,0x00,0x00,0x00,0x21,
0xFE,0x01,0xC0,0x00,0x70,0x03,0xFF,0xE3,0x01,0x80,0x1F,0x80,0x00,0x00,0x00,0x1C,
0xFC,0x01,0x80,0x01,0x80,0x1D,0x98,0x0E,0xE0,0x10,0x07,0xFC,0x00,0x00,0x00,0x20,
0x00,0x03,0x00,0x1C,0x13,0xFF,0xC8,0x03,0x98,0x04,0x03,0xF8,0x00,0x00,0x00,0x20,
0x00,0x02,0x03,0xC4,0x9F,0xFF,0xF1,0x0F,0xFB,0x01,0x81,0xE0,0x00,0x00,0x00,0x3F,
0x00,0x00,0x1C,0x10,0xFF,0xE3,0xF9,0x06,0x7E,0xE0,0x40,0x00,0x00,0x00,0x00,0x1F,
0x00,0x00,0xE4,0xA7,0xFF,0xE6,0x78,0x00,0xE1,0xF0,0x30,0x00,0x00,0x00,0x00,0x0F,
0xC8,0x1F,0xDF,0x3D,0xFF,0xFC,0x7E,0x01,0xE0,0x7C,0x0C,0x00,0x00,0x00,0x00,0x02,
0x23,0xE3,0xFB,0xFF,0xFF,0xF8,0x7A,0x00,0x20,0x1A,0x07,0xC0,0x00,0x00,0x00,0x00,
0x18,0x00,0xE7,0xFE,0x7F,0xFC,0x7E,0xE0,0x20,0x0D,0x83,0xF0,0x00,0x00,0x00,0x00,
0x00,0x07,0xFF,0xBF,0xFF,0xFF,0xFE,0x80,0x60,0x02,0xC0,0x1F,0xF8,0x00,0x00,0x02,
0x08,0x1F,0x67,0xD3,0xFF,0xFF,0xFE,0x20,0xE0,0x01,0xA1,0xC5,0xC0,0x00,0x00,0x00,
0x83,0x1D,0x87,0xF7,0xBF,0xFF,0xFE,0x00,0x20,0x00,0x51,0x80,0x00,0x00,0x00,0x00,
0x63,0xFE,0x04,0x19,0xFF,0xFD,0xFC,0x01,0xC0,0x00,0x29,0x00,0x00,0x00,0x00,0x02,
0x1C,0x78,0x03,0x47,0xBF,0xFF,0xBD,0x00,0x40,0x00,0x10,0x00,0x00,0x00,0x00,0x00,
0x9F,0xA0,0x03,0x19,0xFF,0xFF,0xBB,0x00,0xC0,0x00,0x10,0x00,0x00,0x00,0x00,0x00,
0xFF,0x40,0x03,0xE3,0x7F,0x7B,0xB2,0x03,0x80,0x00,0x28,0x00,0x00,0x00,0x00,0x0F,
0x0F,0xA0,0x00,0xCC,0x6B,0xDF,0xC1,0x03,0x80,0x00,0x14,0x00,0x00,0x00,0x00,0x60,
0x0C,0x80,0x00,0xF0,0x8C,0x7C,0x21,0x07,0x00,0x00,0x32,0x00,0x00,0x00,0x00,0x1F,
0xF0,0xC0,0x00,0x61,0x10,0x00,0x21,0x06,0x00,0x00,0x63,0x00,0x00,0x00,0x00,0x3F,
0xC3,0xE8,0x00,0x32,0x20,0x20,0x10,0x14,0x00,0x00,0xA9,0x80,0x00,0x00,0x00,0x0F,
0x69,0xF4,0x00,0x1C,0x40,0x20,0x00,0x38,0x00,0x01,0x80,0x80,0x00,0x00,0x00,0x01,
0xFE,0xB4,0x00,0x1C,0x40,0x00,0x00,0x50,0x00,0x03,0x87,0x40,0x00,0x00,0x00,0x00,
0x6F,0x7C,0x00,0x06,0x80,0x00,0x07,0x60,0x00,0x03,0x6C,0x80,0x00,0x00,0x00,0x00,
0x1E,0xCF,0x80,0x03,0x10,0x00,0x11,0x80,0x00,0x05,0x83,0x80,0x00,0x00,0x00,0x00,
0x0B,0x77,0x80,0x00,0xC9,0x00,0x63,0x00,0x00,0x0A,0x00,0x00,0x00,0x00,0x00,0x00,
0x01,0x8C,0xE0,0x00,0x21,0xD0,0x18,0x00,0x00,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xA3,0x3C,0x00,0x1C,0x01,0xE0,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x14,0x63,0xC0,0x00,0x40,0x00,0x00,0x00,0x80,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x01,0x1F,0x70,0x00,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x40,0xE7,0x80,0x00,0x00,0x00,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x1E,0x78,0x00,0x00,0x00,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x01,0xC7,0x00,0x00,0x1F,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x3E,0x7F,0xFB,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x03,0xF8,0x07,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x1F,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

                    
HDT_entry_type HDT[] =
{                   
    {MOTOR,MOTOR_LEFT,"MotA-L",  (void *)&motorA},
    {MOTOR,MOTOR_RIGHT,"MotB-R",(void *)&motorB},
    {QUAD, QUAD_LEFT,"LEFT",   (void *)&encoderA},
    {QUAD, QUAD_RIGHT,"RIGHT", (void *)&encoderB},
    {VW,VW,"Drive",(void *)&drive},
                    
    /* {BUMP, BUMP_LEFT,"LEFT",(void *)&bumper0}, */
    /* {IR, IR_LF,"LF",(void *)&ir0},             */
                    
    {SERVO,SERVO1, "SERV01",(void *)&servo1},
    {SERVO,SERVO2, "SERV02",(void *)&servo2},
    {SERVO,SERVO3, "SERV03",(void *)&servo3},
    {SERVO,SERVO4, "SERV04",(void *)&servo4},
    {SERVO,SERVO5, "SERV05",(void *)&servo5},
    {SERVO,SERVO6, "SERV06",(void *)&servo6},
    {SERVO,SERVO7, "SERV07",(void *)&servo7},
    {SERVO,SERVO8, "SERV08",(void *)&servo8},
    {SERVO,SERVO9, "SERV09",(void *)&servo9},
    {SERVO,SERVO10,"SERV10",(void *)&servo10},
    {SERVO,SERVO11,"SERV11",(void *)&servo11},
    {SERVO,SERVO12,"SERV12",(void *)&servo12},
                    
    {PSD,PSD_FRONT,    "P0-F",  (void *)&psd0},
    {PSD,PSD_LEFT,     "P1-L",  (void *)&psd1},
    {PSD,PSD_RIGHT,    "P2-R",  (void *)&psd2},
    {PSD,PSD_LEFTDIAG, "P3-LD", (void *)&psd3},
    {PSD,PSD_RIGHTDIAG,"P4-RD", (void *)&psd4},
    {PSD,PSD_BACK,     "P5-BK", (void *)&psd5},
    {COMPASS,COMPASS,"COMPAS",(void *)&compass},
                    
    {WAIT,WAIT,"WAIT",(void *)&waitstates},
    {INFO,INFO,"INFO",(void *)&roboinfo},
                    
    {STARTMELODY,STARTMELODY,"Melody",(void *)startmelody},
    {STARTIMAGE,STARTIMAGE,"Image",(void *)&startimage},
                    
    {END_OF_HDT,UNKNOWN_SEMANTICS,"END",(void *)0}
};
                  
