/*
| ------------------------------------------------------------------------------
| Filename: johnny.c
|
| Author:       Thomas Braunl  (braunl@ee.uwa.edu.au)
| Modified: 	Alistair Sutherland, Martin Wicke 19/5/2000
| Description: 
| -------
| HDT data for biped walker 
| ------------------------------------------------------------------------------
*/

#define VERSION 2.0             /* User specific version nr. just for inform. */
#define NAME "Johnny"           /* Unique platform name max. 10 chars,inform. */
#define ID   21                 /* Unique platform id (unsigned char) */

#include "hdt.h"
#include "hdt_sem.h"

/* The HDT structure */
/*-------------------*/
int     		magic = 123456789;
extern 	HDT_entry_type 	HDT[];
HDT_entry_type  	*hdtbase = &HDT[0];

#include "types.h"
#include "const.h"
#include "rs232.h"
#include "cam.h"
#include "librobi/librobi.h"

/* > is right and forward */
/* < is left and backward */

/* Timer2, 20ms period, 0.7ms min, 1.7ms max */           
servo_type _RHipT_   = {2,  0, TIMER2, 20000, 722, 1600};   
servo_type _RHipB_   = {2,  1, TIMER2, 20000, 1976, 376};   
servo_type _RKnee_   = {2,  2, TIMER2, 20000, 740, 2340};   
servo_type _RAnkle_  = {2,  3, TIMER2, 20000, 1970, 970};  
servo_type _Torso_   = {2,  4, TIMER2, 20000, 825, 1575};   
servo_type _LAnkle_  = {2, 11, TIMER2, 20000, 970, 1970};   
servo_type _LKnee_   = {2, 12, TIMER2, 20000, 2458, 858};   
servo_type _LHipB_   = {2, 13, TIMER2, 20000, 388, 1964};   
servo_type _LHipT_   = {2, 14, TIMER2, 20000, 808, 1608};   

info_type roboinfo = {0,WALKER,SER115200,RTSCTS,SERIAL1,0,OFF,AUTOBRIGHTNESS,BATTERY_OFF,30,VERSION,NAME,ID};

/* waitstates = 0..13, Fast Termination = 14, External = 15 */
/* Version, ROM, RAM, LCD, IO, Parallel+Serial2/3 */
/* 16MHz - 20Mhz */
/* waitstate_type waitstates = {0,3,0,1,0,2}; */
/* 21MHz - 41Mhz */
waitstate_type waitstates = {0,3,1,2,1,2};

/* HDT for two legged walker */

HDT_entry_type HDT[] =
{
    {SERVO, RHipT,  "RHipT", (void *)&_RHipT_},
    {SERVO, RHipB,  "RHipB", (void *)&_RHipB_},
    {SERVO, RKnee,  "RKnee", (void *)&_RKnee_},
    {SERVO, RAnkle, "RAnkle",(void *)&_RAnkle_},
    {SERVO, Torso,  "Torso", (void *)&_Torso_},

    {SERVO, LAnkle, "LAnkle",(void *)&_LAnkle_},
    {SERVO, LKnee,  "LKnee", (void *)&_LKnee_},
    {SERVO, LHipB,  "LHipB", (void *)&_LHipB_},
    {SERVO, LHipT,  "LHipT", (void *)&_LHipT_},

    {WAIT,  WAIT,   "WAIT",  (void *)&waitstates},
    {INFO,  INFO,   "INFO",  (void *)&roboinfo},

    {END_OF_HDT, UNKNOWN_SEMANTICS, "END", (void *)0}
};
