#ifndef GPS_H
#define GPS_H
/****************************************************************************
GPS.h - Created by Peter Mauger 20/06/01
Last Modified 20/09/01

GPS contains all of the functions required to communicate with the GPS and 
extract information from the messages.
****************************************************************************/

#include "include.h"

/* Init_GPS initialises the GPS communications channel and makes sure data
* has been received
* returns: FALSE if the initialisation failed
* 	   TRUE if the initialisation was successful
*/
bool Init_GPS();

/* Test_GPS checks for a message to make sure consistent data is coming
* through the link
* returns: FALSE if no message was found
*	   TRUE if a message was found
*/
bool Test_GPS();

/* Obtain_GPS_Position determines whether a message has been completed or not and
* gets the position if it has been, or gets more of the message if it hasn't
* inputs:  plane->used to log an error if it occurs
*	   header->contains the header of the message to be retrieved
* 	   mesg->contains the current message fragment
* returns: FALSE if the position was not updated
*	   TRUE if the position has been updated
*/
bool Obtain_GPS_Position(planestate *plane);

/* Obtain_Message searches through one burst of data from the GPS for
* the message header passed to it
* inputs:  header->the header of the message required
*	   mesg->returns the current part of the message in a message structure
* returns: MESGTOOLONG if the message was longer than MAX_MESG_LENGTH
*	   NOERROR if either the message was found (mesg->complete == TRUE) 
*		or if the maximum read for this call was reached (mesg->complete == FALSE)
*/
error Obtain_Message(char header[HDR_LENGTH], message *mesg);

/* Obtain_Position_From_Mesg retrieves the data from GLL messages.
* It expects a certain format, and if this is not adhered to will fail
* inputs:  mesg->contains the GLL message
*	   pos->returns the data from the message
* returns: FALSE if the message is incorrect
*	   TRUE if the data has been successfully retrieved
*/
bool Obtain_Position_From_Mesg(message *mesg, position *pos);

/* CommaCheck makes sure that the current character is a comma
* inputs:  mesg->contains the message and a pointer to the current character
* returns: FALSE if there wasn't a comma
*	   TRUE if there was one
*/
bool CommaCheck( message *mesg );

/* ReadValue reads a string from before a comma (or the end of the message)
* from the message
* inputs:  value->the string read
* returns: FALSE if no string was found (ie up to a comma or end of message)
*	   TRUE if a string was returned
*/
bool ReadValue( char *value, message *mesg );

/* ChecksumCheck determines whether the checksum is correct for that message
* inputs:  mesg->contains the message data and a pointer to the checksum (hopefully)
* returns: FALSE if the checksum was incorrect (or not correct format)
*	   TRUE if the message was correctly received
*/
bool ChecksumCheck( message *mesg );

/* Convert_HexStringToDecInt simply converts a two character hexadecimal 
* string into an decimal integer value
* inputs:  csum_read_str->contains the hex value
* returns: the decimal value of the hex string
*/
int Convert_HexStringToDecInt( char csum_read_str[3] );

#endif







