/**
@name randrive.c
@author Andrew Berry
@revision Peter Vanopulos
@date Original source code created on: unknown, 
      Revised: 29/11/1999
.This is a program to move the robot around to test the battery life.
*/


#include "eyebot.h"
#include <stdlib.h>
#include <math.h>

#define v_lin 1.0
#define t_lin 0.3
#define v_rot 1.0
#define t_rot 0.3   

#define CLEAR()		( PSDGet( psd_front ) > 200 && PSDGet( psd_left ) > 200 && PSDGet( psd_right ) > 200 )

MotorHandle     leftmotor, leftmotor;
PSDHandle       psd_front, psd_left, psd_right;
VWHandle        vw;

MotorHandle	ml,mr;

int main ()
{       /* write message */
        LCDMenu("","","","END");

        LCDPutString("Roll on ...\n");
        vw=VWInit(VW_DRIVE,1);
        
        psd_front = PSDInit(PSD_FRONT);
        psd_left = PSDInit(PSD_LEFT);
        psd_right = PSDInit(PSD_RIGHT);
        PSDStart(psd_front, TRUE);
        PSDStart(psd_left,TRUE);
        PSDStart(psd_right,TRUE);
        //VWStartControl(vw, v_lin, t_lin , v_rot, t_rot);
        VWStartControl(vw, 10.0, 5.0, 1.0, 0.1);

	while(1)
	{
	  VWDriveTurn( vw, 2*M_PI, 6 );
	  VWDriveWait( vw );
	}
        
	LCDPutString( "Forward\n" );
	VWSetSpeed(vw,0.2,0.0);

        while(KEYRead() != KEY4)
        {
	    if( !CLEAR() )
	    {
		LCDPutString( "Stop and spin\n" );
		VWSetSpeed(vw,0.0,0.0);
		//VWDriveStraight( vw, -0.2, 0.1 ); // back off 20cm
		VWDriveWait( vw );
		VWRelease( vw );
		ml = MOTORInit( MOTOR_LEFT );
		mr = MOTORInit( MOTOR_RIGHT );
		MOTORDrive( ml, 50 );
		MOTORDrive( mr, -50 );
		OSWait( 100 );
		do
		{
		    //VWDriveTurn( vw, (rand()%2?-1:1)*M_PI/4, M_PI/2 );
		    //VWDriveWait( vw );
		}
		while( !CLEAR() );
		MOTORRelease( ml );
		MOTORRelease( mr );
		vw = VWInit( VW_DRIVE, 1 );
		LCDPutString( "Forward\n" );
		VWSetSpeed(vw,0.2,0.0);
	    }
        }/* end while loop */

        return 0;
}

