/** Get angle.
    Get angle between robot orientation phi and line to point
    (diffx, diffy).
*/
float get_angle(float diffx, float diffy, float phi);


/** Drive Spline IRQ.
    Drive curve from startpos to endpos, considering orientation.
*/
void drive_spline_IRQ();

/** Start Spline.
    Start timer function which calls drive_spline every loop_time
    mseconds.
*/
void start_spline(PositionType startpos, PositionType endpos);

/**
   Stop Spline.
*/
void stop_spline();

/**
   Spline Done.
*/
int spline_done();

/** Attach drive_spline_IRQ to timer.
 */
void start_spline_IRQ();

/** Detach drive_spline_IRQ to timer.
 */
void stop_spline_IRQ();


