/*****
*Property of the University of British Columbia (UBC),
*Copyright 2001, by UBC.
*
*By receiving this code, you are agreeing to the following terms:
*1. You will use this code for academic purposes only.
*2. For academic use only, you may distribute the binary or executable code
*   to persons at UBC or the Univ. of Western Australia who have previously 
*   read and agreed to these terms, but you must distribute the SOURCE code
*   with it. 
*3. Each file of source code so distributed must have this header attached.
*4. If the code is revised, the programmer's name and revision date must be added
*   to the Revision List below, as well as the revisions identified in the code.
*5. You will not make this code more widely available via any method such as 
*   publishing in print, email mail-list, usenet posting, website etc.
*6. UBC reserves all rights to this work and all derivative works.
*
*For other proposed purposes please contact:
*The University-Industry Liaison Office 
*IRC Room 331 - 2194 Health Sciences Mall 
*University of British Columbia 
*Vancouver, BC, Canada V6T 1Z3 
*Tel: (604) 822-8580 
*Fax: (604) 822-8589 
*
*or contact: 
*Peter D. Lawrence, Professor at peterl@ece.ubc.ca or 
*Greg Z. Grudic, Assistant Professor, at grudic@cs.colorado.edu
*
*Revision List: 
*Greg Grudic, August 28, 1998.
*****/

/*
%
% File:		b_pc.h
% Program: 	Header file for Functional Approximation code
%
% Author:	Greg Grudic 
%
*/

#include <stdio.h>
#include "pc.h"

/***************************************/
/*** the following need to be set ******/
/***************************************/

#define ERROR_DECREASE_CONSTANT 0.0001

#define INNER_ERR_LOOP 25 
#define OUTER_ERR_LOOP  6

#define MAX_SV_RATIO       1.0e8

#define THRESHOLD_MIN_MAX  1.0e-8

/***************************************/
/***************************************/
/***************************************/


#undef ANALYZE_INPUTS

My_Real **Create_Matrix(int rows, int cols);

void My_Error(char error_text[]);

double erand48(unsigned short xsubi[3]);

double Greg_Rand(unsigned short xsubi[3]);

struct Poly_Delete_Structure_defn
{
  Poly *pp;

  My_Real ave_value;
};

typedef struct Poly_Delete_Structure_defn Poly_Delete_Structure;

struct Error_Struc_defn
{
  My_Real err, tot_b_val;

  Poly *pp;

  struct Error_Struc_defn *n_e;
};

typedef struct Error_Struc_defn Error_Struc;

struct Mse_Struct_defn
{
  My_Real mse_inv;
  My_Real b_val;
  struct Mse_Struct_defn *next_mse;
};

typedef struct Mse_Struct_defn Mse_Struct;

struct Build_Cas_Poly_defn
{
  int lrn_num;

  int inner_cnt, outer_cnt;
  My_Real inner_err_loop[25];
  My_Real outer_err_loop[6];

  Poly_Delete_Structure outer_poly_loop[6];

  My_Real **p_mat, *p_b, *p_sv, *p_c;
  My_Real **s_mat, *s_b, *s_sv, *s_c;

  Error_Struc *err_st;
  Error_Struc *err_pt;
  My_Real b_il_err;
  int il_be_ind;

  My_Real *h_p_lrn_best;
  My_Real *h_p_val_best;

  My_Real *curr_to_lrn_best;
  My_Real *curr_to_val_best;

  Poly *last_poly_prev_inner_loop;
  int first_poly_built;

  My_Real mse_inv_tot;
  My_Real curr_b_val;
  Mse_Struct *mse_st;
  Mse_Struct *mse_pt;

  My_Real *p_mat_array;
  My_Real *p_b_all;
  My_Real *dres_tm;

  My_Real *s_mat_array;
  My_Real *s_b_all;
  My_Real *s_dres_tm;

  Poly *c_p;

  int num_lrn_ex;
  int num_val_ex;

  My_Real m_out, b_out;

  My_Real curr_const_tot;

  My_Real *out_val;
  My_Real *out_lrn;

  My_Real *h_p_lrn;
  My_Real *h_p_val;

  My_Real *curr_o_lrn;
  My_Real *curr_o_val;

  My_Real *curr_to_lrn;
  My_Real *curr_to_val;

  int Lrn_Num_Sch[4], cnt_Lrn_Num_Sch;

  int *select_input_list;
  int curr_input_ind_num;

  Poly *address_of_1st_in_bag;
  int curr_num_of_bags;

  unsigned short xsubi[3];

  Cascade_Poly *pc;

#ifdef ANALYZE_INPUTS
  My_Real *ana_var_num;
  int *ana_var_tot_used;
  int ana_var_cnt;
  My_Real ana_var_prev_alpha;
#endif	  

};


struct Comp_Structure_defn
{
  float t;
  int order;
};

typedef struct Comp_Structure_defn  Comp_Structure;

typedef struct  Build_Cas_Poly_defn Build_Cas_Poly;
