#ifndef INCLUDE_H
#define INCLUDE_H
/***********************************************************************
include.h - Created by Peter Mauger 24/07/01
Last Modified 12/10/01

include provides all of the header files that are needed as well as defining the
structures that will be used in the program. These structs should only be
manipulated by the functions provided in the relevant header files.
***********************************************************************/
#include "planeconst.h"
#include "eyebot.h"
#include "irtv.h"
#include "IRnokia_vcn620.h" 
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>
#include <math.h>

typedef struct {	/* Message storage object */
	char buffer[MAX_MESSAGE_LENGTH];	/* the string of the message */
	int mesg_length;	/* the length of the message string */
 	int mesg_ptr;	/* pointer to character being examined */
	bool valid;	/* TRUE = correct header found (read in rest of message) */
	bool complete;	/* TRUE = correct message */
} message;

typedef struct {	/* A geometric coordinates position */
	double latitude;	/* latitude of the position(+ve for NORTH, -ve for SOUTH) */
	double longitude;	/* longitude of the position (+ve for EAST, -ve for WEST) */
} position;

typedef struct {  	/* Contains a lof of all events. Index separate for each event */
	error tag[MAX_ERROR_MESGS];	/* set of identifiers of the events (must be defined in type error) */
	position gps_pos[MAX_ERROR_MESGS];	/* set of positions of the events */
	position wp_pos[MAX_ERROR_MESGS];	/* set of positions of the events */
	int heading[MAX_ERROR_MESGS];	/* set of headings of the events */
	double bearing[MAX_ERROR_MESGS];	/* set of headings of the events */
	int curr_error_num;	/* current number of events logged */
} errorlog;

typedef struct {			/* List of waypoints the plane must travel to */
	position wps[MAX_WAYPOINTS];	/* waypoints in order of travel */
	int total_wps;	/* total number of waypoints in array */
} wplist;

typedef struct {			/* Plane Position data */
	turnstate desired_turn;		/* turn state of aircraft(Left, Right, Straight)*/
	altitudestate desired_altitude;	/* change in altitude required(higher, lower, level)*/
	
	wplist waypoints;		/* List of all waypoints for flight*/
	
	double altitude;		/* current altitude*/
	message gps_mesg;		/* current message fragment from the GPS */
	position curr_pos;		/* current position */
	position curr_wp;		/* the waypoint the plane is trying to reach*/
	position stored_pos;		/* stores old position */
	int curr_heading;		/* current heading (degrees 0->360) */
	double req_bearing;		/* the bearing required to reach the next waypoint */
	int stored_heading;		/* stores old heading */
	double pitch;			/* current pitch*/
	double bank_angle;		/* current bank angle*/
	double airspeed;		/* current airspeed*/
	double best_correction;	/* Best correction value acheived. Not improved */
	int improve_count;		/* on in 20 cycles opposite turn adopted. */
/* Allows plane to recognise turns through the */   /* wind and go around rather than trying to */         /* make a turn it cannot possibly achieve*/
} planeposstate;

typedef struct {			/* Data set for one control surface */
	servoconsts id;			/* identifies the control surface */
	double angle;			/* current angle of control surface from neutral */
	ServoHandle servo;		/* the servo that controls this surface */
	double max_limit, min_limit;	/* angular limits of servo (determined by user) */
	double neutral_point;
} ctrlsurface;

typedef struct {			/* Plane Control State data*/
	turnstate rudder_state;		/* Direction of rudder (Left, Right, Straight)*/
	ctrlsurface rudder;		/* Current state of the rudder control surface*/
	ctrlsurface banking;		/* Current state of the gyroscope control surface */
	ctrlsurface elevator;		/* Current state of the elevator control surface */
	ctrlsurface throttle;		/* Current state of the throttle control surface */
} planectrlstate;

 
typedef struct {			/* Current plane state data*/
	planeposstate position;	/* position data*/
	planectrlstate control;		/* control data*/
	errorlog log;			/* log of all events and errors during a flight */
} planestate;

#include "position.h"
#include "GPS.h"
#include "waypoint.h"
#include "plane.h"
#include "hardware.h"
#include "compass.h"
#include "autopilot.h"
#include "menu.h"

#endif 

