/** @name structure_definitions.c 

    This file contains structures that are used in the commiunications system.

    @author Daniel Storey, UWA, 1998
    @version 1.0   */

/*@{*/

/** Boolean data type */
typedef int bool;

/** Buffer structure for RS232 Serial data */ 
struct buffer {
  /** start pointer */
  int start;
  /** end pointer */
  int end;
  /** current buffer length */
  int length;
  /** buffer storage */
  char data[BUFFER_LENGTH+1];
};

typedef struct buffer Buffer;

/** Structure to hold a packet of data */
struct packet {
  /** start string for a packet */
  char start[2];
  /** number of the packet */
  char number[2];
  /** destination address of the packet as a string */
  char destination_address[ADDRESS_LEN + 1];
  /** source address of the packet as a string */
  char source_address[ADDRESS_LEN + 1];
  /** type of packet */
  char type[PACKET_TYPE_BYTES + 1];
  /** data that is to be transferred as a string */
  char data[MAXIMUM_DATA_LENGTH + 1];
  /** crc check of the data as a string */
  char crc[CRC_BYTES + 1];
  /** end string for a packet */
  char end[2];
  /** number of times the packet has been sent */
  int sent;
};

typedef struct packet Packet;

/** item in a list */
struct item {
  /** Structure to hold a packet of data */
  Packet packet;
  /** index number of the item */
  int index;
};

typedef struct item Item;

/** a queue structure to hold outgoing regular packets */
struct queue {
  /** array of packets that are in the queue */
  Item item[QUEUE_ELEMENTS];
  /** number of items in the queue */
  int cnt;
};

typedef struct queue Queue;

/** a queue to hold outgoing special packets */
struct special_queue {
  /** array of packets that are in the queue */
  Item item[SPECIAL_QUEUE_ELEMENTS];
  /** number of items in the queue */
  int cnt;
};

typedef struct special_queue Special_Queue;

/** an item containing an incomming string an an index number */
struct string_item {
  /** string of data that is held in a queue */
  char string[MAXIMUM_TOTAL_PACKET_LENGTH + 1];
  /** address from which the string was received */
  char address[ADDRESS_LEN+1];
  /** index number of the item */
  int index;
};

typedef struct string_item String_Item;

/** a queue to hold incomming strings */
struct string_queue {
  /** array containing strings of data that has been received*/
  String_Item string_item[STRING_QUEUE_ELEMENTS];
  /** number of items in the queue */
  int cnt;
};

typedef struct string_queue String_Queue;

/** an item containing the number and source of recent frames */
struct recframe_item {
  /** frame number */
  char number;
  /** address from which the string was received */
  char address[ADDRESS_LEN+1];
  /** age of the item */
  int age;
  /** index number of the item */
  int index;
};

typedef struct recframe_item RecFrameItem; 

/** a queue to hold the number and source of recent frames */
struct recframe_queue {
  /** array containing queue elements */
  RecFrameItem recframe_item[RECENT_FRAME_QUEUE_ELEMENTS];
  /** number of items in the queue */
  int cnt;
};

typedef struct recframe_queue RecFrame_Queue;

/** channel information */
struct channel {
  /** communications link speed */
  int baudrate;
  /** number of the last packet sent */
  char last_packet_number;
  /** Addresses of this station */
  char my_address[ADDRESS_LEN + 1];
  /** Address of the next station in the control loop */
  char next_address[ADDRESS_LEN + 1];
  /** Address to which packets that are broadcast will be sent */
  char broadcast_address[ADDRESS_LEN + 1];
  /** Preamble to be sent before transmission over a wireless link */
  char preamble[PREAMBLE_BYTES + 1];
  /** Space to store raw frames */
  char raw[MAXIMUM_TOTAL_PACKET_LENGTH + 1];
  /** Length of valid data in the raw frame */
  int raw_length;
  /** Indicates whether the raw frame is valid */
  bool raw_valid;
  /** Indicates the number of timeouts that have been called */
  int timeout;
  /** Wireless = TRUE, Cord = FALSE */
  bool wireless;
  /** Master station True/False */
  bool master;
  /** Queue for recent frames received details */
  RecFrame_Queue recframe_queue;
  /** Queue for special packets to be sent */
  Special_Queue special_sending;
  /** Queue for incommind data strings */
  String_Queue string_receiving;
  /** Queue for packets that are to be sent */
  Queue sending;
  /** Queue for sending errors received from the lowest layer of the network */
  Queue error;
  /** Status of the token at this station */
  bool token;
};

typedef struct channel Channel;





