// Test Gyroscope output
#include <stdlib.h>
#include <string.h>
#include "irtv.h"
#include "eyebot.h"
#include "Gyro.h"
#include "Motors.h"
#include "IRnokia.h"

// was 40
#define K1 40.0
#define K2 3.3
#define K3 3.4
#define K4 0.6

#define SAMPLE_INTERVAL 3

#define MAX_STATES_STORED 250

#define MAX_IMAGES 1

// Prototypes
void SampleState();
void *memset( void *dest, int c, size_t count );
int TransmitLine232(char * sz);


// Global variables (needs to be shared with timer handler)
struct {
	float fAngle;
	float fAngVel;
	float fX;
	float fXVel;
	int   iTime;
} g_StateHistory[MAX_STATES_STORED] = {0};

int g_iSampleCount;
int g_iFirstSample;
int g_iHasBeeped;

int g_iLastTimeStamp;
float g_fLastDisplacement;

// The gyroscope ...
CGyro * g_pGyro;

// The motors ...
CMotors * g_pMotors;
int g_iMotorsOn;

main( )
{
	//////////////////////////////////////////////////////////
	// This does nothing, but is required due to Robios bug //
	float * fp = (float *)malloc(4); if (fp) free (fp);     //
	//////////////////////////////////////////////////////////

	int iKey;
	colimage Images[MAX_IMAGES];
	int cImages;
	int i;

	TimerHandle hGyroTimer;

	// Create the motors
	g_pMotors = new CMotors;

	// Init variables
	iKey = 0;
	cImages = 0;
	g_iSampleCount = 0;
	g_iFirstSample = 1; // True initially
	g_iLastTimeStamp = 0;
	g_fLastDisplacement = 0;
	g_iMotorsOn = 1;
	g_iHasBeeped = 0;

	// Init IR:
	LCDPrintf("IRTVInit: %d\n", IRTVInit(SPACE_CODE,15,0,0x03ff,SLOPPY_MODE,1,10));

	// Create the gyroscope
	g_pGyro = new CGyro;

	// Recalibrate gyro
	g_pGyro->Recalibrate();

	LCDClear();

	// Initialise distance to zero, and get start time
	g_pMotors->Reset();
	memset(&g_StateHistory, 0, sizeof(g_StateHistory));
	g_StateHistory[0].iTime = OSGetCount();

	// Start timer to handle samples
	hGyroTimer = OSAttachTimer(SAMPLE_INTERVAL, (TimerFnc) (SampleState));

	// Now take samples until whenever...
	while ( g_iMotorsOn == 1 && iKey != KEY4)
	{

		switch (iKey = IRTVRead())
		{
			case 0: break;
			
	  		case RC_FF:
	  			LCDPrintf("FF\n");
	  			break;			
	  		case RC_RW:
	  			LCDPrintf("RW\n");
	  			break;			

			case RC_1:
			  	LCDPrintf("1\n");
				g_iMotorsOn = 1;
			  	break;

			case RC_RECORD:
			  	break;

			case RC_3:  // MOTORS OFF & send back data

			  	LCDPrintf("3\n");
				// Disable timer...
				OSDetachTimer( hGyroTimer );

				// Motors off!..
				g_iMotorsOn = 0;
				g_pMotors->SetForce(0, 0);

				LCDPrintf("DONE!\n");
		
				break;

			default:
				break;
		}
		
		// Check for commands:
		iKey = KEYRead();
		if (iKey == KEY4)
		{
			OSDetachTimer( hGyroTimer );

			// Motors off!..
			g_iMotorsOn = 0;
			g_pMotors->SetForce(0, 0);
		}
	}

	// destroy the gyroscope & motors
	IRTVTerm();
	delete g_pGyro;
	delete g_pMotors;
}



//////////////////////////////////////////////////////////
//
// SAMPLE STATE
//
// Read gyroscope and odometers to get state estimates & 
// make control decision
//
void SampleState()
{
	int iVoltage;
	float fVoltage;
	float fForce;

	// Get time ...
	g_StateHistory[g_iSampleCount].iTime = OSGetCount();

	// Get current state:
	g_StateHistory[g_iSampleCount].fAngle =	g_pGyro->GetAngle();
	g_StateHistory[g_iSampleCount].fAngVel = g_pGyro->GetAngularVel();
	g_StateHistory[g_iSampleCount].fX =		g_pMotors->GetDistance();

	if (g_iFirstSample)
	{
		g_StateHistory[g_iSampleCount].fXVel = 0.0;
		g_iFirstSample = 0;
	}
	else
	{
		g_StateHistory[g_iSampleCount].fXVel =	(g_StateHistory[g_iSampleCount].fX - g_fLastDisplacement ) / 
							(g_StateHistory[g_iSampleCount].iTime - g_iLastTimeStamp);
	}

	g_iLastTimeStamp = g_StateHistory[g_iSampleCount].iTime;
	g_fLastDisplacement = g_StateHistory[g_iSampleCount].fX;

	// Calculate desired force...
	fForce = g_StateHistory[g_iSampleCount].fAngle * K1 + g_StateHistory[g_iSampleCount].fAngVel * K2 + g_StateHistory[g_iSampleCount].fX * K3 + g_StateHistory[g_iSampleCount].fXVel * K4;

	// Set force...
	if (g_iMotorsOn == 1)
		g_pMotors->SetForce(fForce, g_StateHistory[g_iSampleCount].fXVel);
	else
		g_pMotors->SetForce(0, 0);

	g_iSampleCount++;
	if (g_iSampleCount >= MAX_STATES_STORED) 
	{
		g_iSampleCount = 0; 
	}
}



