extern "C"
{
#include "eyebot.h"
#include "ppwa.h"
}

// Error codes
#define GYRO_FAIL -1
#define GYRO_OK    0

#define INIT_SAMPLES 50
#define INIT_DELAY 100
#define PI 3.14159

// AD Channel for Inclinometer
#define INCLINE_CHANNEL 2

// Prototypes...
int TransmitLine(char * sz);
int TransmitSample(int iTime, int iIncline, int iAngle, int iAngleVel);

////////////////////////////////////////////////
//
// GYRO
//
// Is a class wrapping the gyroscope sensor
//
class CGyro
{
public:
	CGyro();
	~CGyro();

	void InitialiseState();
	void Recalibrate();
	float GetAngle();
	float GetAngularVel();
	int GetTimeSinceCalibration();
	void DisplayAngularVelocity();
	void AdjustMaxAngle(int iGUnits);

protected:
	int m_iZeroVelocity;
	int m_iAngularVelocity;
	int m_iAngle;
	int m_iSampleTime;
	int m_iMaxAngle;
	int m_iZeroAngle;
	int m_iTimeLastCalibrated;
	TimerHandle m_hSampleTimer;
	ServoHandle m_hServo;
	void ZeroAngVel();
	void TimerSample();
};

