#include "eyebot.h"

// Error codes
#define MOTOR_FAIL -1
#define MOTOR_OK    0

//2.7
#define P_ 2.7
//0.3
#define I_ 0.3
//0.5
#define D_ 0.5

// 0.7
#define FRICTION_FORCE  0.85

////////////////////////////////////////////////
//
// MOTOR
//
// Is a class wrapping the motors
//
class CMotors
{
public:
	CMotors();
	~CMotors();
 
	int Reset();
	int SetForce(float fNewtons, float fVelocity);
	float GetDistance();

protected:
	MotorHandle m_motorLeft;
	MotorHandle m_motorRight;
	QuadHandle m_quadLeft;
	QuadHandle m_quadRight;

	float m_fLastError;
	float m_fIntegratedError;
	float m_fCorrection;
	int m_iPIDCounter;
	float m_fLeftDistance;
	float m_fRightDistance;
};
;

