// Test TPU output
#include <stdlib.h>
#include "eyebot.h"

#define MAX_SAMPLES 4000
#define MINY 5500
#define MAXY 8500

#define FREE_EXIT(x)							\
	{											\
		if (rgiTPU7)   free(rgiTPU7);			\
		return (x);								\
	}

// Prototypes...
int ScaleDataToScreen64(int iMinY,int iMaxY,int iY);

main( )
{
	int iKey;
	int iSampleNumber;
	int iStart;
	int iEnd;
	int i, j, k;

	// Initialise sample arrays
	int * rgiTPU7;

	// Allocate memory for accn sensor samples
	rgiTPU7 = (int *)malloc(MAX_SAMPLES * sizeof(int));
	if (rgiTPU7 == NULL)
	{
		LCDPrintf("Failed to malloc rgiTPU7\n");
		FREE_EXIT(-1);
	}
	
	LCDPrintf("Ready to read TPU 7!\n");
	LCDPrintf(" - KEY1 to strt\n");
	LCDPrintf(" - KEY1 to stop\n");

	// Wait for KEY1 before starting
	iKey = KEYGet();
	iKey = 0;

	// Beep three times before starting
	AUBeep();
	OSWait(100);
	AUBeep();
	OSWait(100);
	AUBeep();

	LCDClear();

	accinit();
	accrelease();
	accinit();

	// Get TPU reading of the first sample
	iSampleNumber = 0;
	for ( rgiTPU7[iSampleNumber]=-1; rgiTPU7[iSampleNumber]<0; rgiTPU7[iSampleNumber] = accreadY()) ;
	iSampleNumber++;

	// Now take samples until the key is pressed again, or we have the maximum...
	while (iKey!=KEY1 && iSampleNumber<MAX_SAMPLES)
	{
		// Get TPU reading
		for ( rgiTPU7[iSampleNumber]=-1; rgiTPU7[iSampleNumber]<0; rgiTPU7[iSampleNumber] = accreadY()) ;
			
		iStart = iSampleNumber-128;
		if (iStart<0) iStart=0;
		iEnd = iSampleNumber;

		// draw graphics 
		for(i=0; i<iEnd-iStart; i++)
        {
			LCDSetPixel(ScaleDataToScreen64(MINY, MAXY, rgiTPU7[i + iStart]),i, 1);
			LCDSetPixel(1 + ScaleDataToScreen64(MINY, MAXY, rgiTPU7[i + iStart]),i, 1);
        }

		// write actual distance and raw-data
		LCDSetPos(7,0);
		LCDPutString("TPU:");
		LCDPutIntS(rgiTPU7[iSampleNumber],6);

		// clear LCD 
		for(i=0; i<iEnd-iStart; i++)
        {
			LCDSetPixel( ScaleDataToScreen64(MINY, MAXY, rgiTPU7[i + iStart]),i, 0);
			LCDSetPixel(1 + ScaleDataToScreen64(MINY, MAXY, rgiTPU7[i + iStart]),i, 0);
        }

		iSampleNumber++;

		iKey = KEYRead();
	}

	// Beep when finished...
	AUBeep();
	LCDPutString("All done!\n");
	iKey = KEYGet();
	
	FREE_EXIT (0);
}

int ScaleDataToScreen64(int iMinY,int iMaxY,int iY)
{
	return (64-((iY - iMinY) * 64) / (iMaxY - iMinY));
}



