	.include "tpuregs.i"

	| will be set to 1 by the interrupt function if new data is available
	.globl NewDataX
NewDataX:	.DS 4	

	.globl NewDataY
NewDataY:	.DS 4


| initialization routine. Will enable ppwa function for channels 5 and 6 and enable interrupts.	
	.globl	accinit
accinit:
	move.l	#INTX,	0x158		| store starting address of interrupt
								| routine for channel 6

	move.l	#INTY,  0x15c		| store starting address of interrupt
								| routine for channel 7
	
	or.w	#0x00c0, cier		| enable interrupts for channel 6,7 
								| set cier to xx xx xx xx 11 xx xx xx

	or.w	#0xff00, cfsr2		| select ppwa function for channel 6,7 (set cfsr2 to ff xx)
		
	and.w	#0x0fff, hsqr1		| 24-bit high time 
	or.w	#0xa000, hsqr1		| set hsqr1 to 10 10 xx xx  xx xx xx xx
		
	move.w	#0x0007, ch6par0	| detect rising edge, no output, no links
	move.w	#0x0100, ch6par1	| maxcount - 1 period
	move.w	#0xff00, ch6par4	| set ACCUM_RATE to 0xFF (only final results needed)

	move.w	#0x0007, ch7par0	| detect rising edge, no output, no links
	move.w	#0x0100, ch7par1	| maxcount - 1 period
	move.w	#0xff00, ch7par4	| set ACCUM_RATE to 0xFF (only final results needed)

	and.w	#0x0fff, hsrr1		| request service to initialize channel 6,7
	or.w	#0xa000, hsrr1		| set hsrr1 to 10 10 xx xx  xx xx xx xx
								
	and.w	#0x0fff, cpr1		| assign middle priority to channel 6, 7
	or.w	#0xa000, cpr1		| set cpr1 to 10 10 xx xx  xx xx xx xx
wait:
	| wait until initialization complete 
	| hsrr1 bits 12, 13 (for channel 6) and 14, 15 (for channel 7) 
	| will be reset to zero if init complete.
	
	move.w	hsrr1,	d0			| get hsrr1
	andi.w	#0xf000, d0			| look at interesting bits only
	bne	wait				| continue if these are zero
	
	| no data available
	move.l  #0x00000000, NewDataX
	move.l	#0x00000000, NewDataY
	rts

| interrupt functions

INTX:
	move.l  #0x00000001, NewDataX | new data arrived

	and.w	#0xffbf	, cier		| no further new data notification (interrupt) until data is read
	andi.w	#0xffbf, cisr		| channel 6 interrupt not asserted
	rte

INTY:	
	move.l  #0x00000001, NewDataY | new data arrived

	and.w	#0xff7f, cier		| no further new data notification (interrupt) until data is read
	andi.w	#0xff7f, cisr		| channel 7 interrupt not asserted
	rte
	
	
| read the values if there are values available
| int accreadX()
	.globl	accreadX			| channel 6
accreadX:  
	cmpi.l  #0x01, NewDataX		
	beq	readokX				| read data if new data available

	move.l  #0xffffffff, d0			| else return -1
	rts
readokX:	
	clr.l	d0				| new data available:
	move.w	ch6par5, d0			| return value
	move.l  #0x00,	NewDataX		| data read
	or.w	#0x0040, cier			| notify on new data
	rts				

| int accreadY	
	.globl	accreadY
accreadY:	
	cmpi.l  #0x01, NewDataY			| as above, for channel 6
	beq	readokY

	move.l  #0xffffffff, d0
	rts
readokY:	
	clr.l	d0
	move.w	ch7par5, d0
	move.l  #0x00,	NewDataY
	or.w	#0x0080, cier	
	rts				

	.globl	accrelease		
accrelease:	
	andi.w	#0x0fff, cpr1		| stop channel 6,7
	andi.w	#0xff3f, cisr		| channel 6,7 interrupt not asserted
	andi.w	#0xff3f, cier		| disable further irq
	move.l  #0x00000000, NewDataX	| no more data
	move.l  #0x00000000, NewDataY	| no more data
	rts	
