/*****
*Property of the University of British Columbia (UBC),
*Copyright 2001, by UBC.
*
*By receiving this code, you are agreeing to the following terms:
*1. You will use this code for academic purposes only.
*2. For academic use only, you may distribute the binary or executable code
*   to persons at UBC or the Univ. of Western Australia who have previously 
*   read and agreed to these terms, but you must distribute the SOURCE code
*   with it. 
*3. Each file of source code so distributed must have this header attached.
*4. If the code is revised, the programmer's name and revision date must be added
*   to the Revision List below, as well as the revisions identified in the code.
*5. You will not make this code more widely available via any method such as 
*   publishing in print, email mail-list, usenet posting, website etc.
*6. UBC reserves all rights to this work and all derivative works.
*
*For other proposed purposes please contact:
*The University-Industry Liaison Office 
*IRC Room 331 - 2194 Health Sciences Mall 
*University of British Columbia 
*Vancouver, BC, Canada V6T 1Z3 
*Tel: (604) 822-8580 
*Fax: (604) 822-8589 
*
*or contact: 
*Peter D. Lawrence, Professor at peterl@ece.ubc.ca or 
*Greg Z. Grudic, Assistant Professor, at grudic@cs.colorado.edu
*
*Revision List: 
*Greg Grudic, August 28, 1998.
*Robin Atkins, August 31, 2000.
*Peter Lawrence, December 31, 2001.
*****/

/*
%
% File:		pc.h
% Program: 	Header file for Functional Approximation code
%
% Author:	Greg Grudic 
%
*/

#include <stdlib.h>
#include <math.h>

#define POLY_DIM 2
#define POLY_TERMS 10

#define MAX_APPROX 10	/*Robin: number of cross-validation sets*/

/*#define ERASE_APPROX_RIGHT_AWAY*/

#define BUILD_APPR			/*Robin: Do Training phase*/
#define TEST_APPROX			/*Robin: Do Testing phase */

#define TRUE	1
#define FALSE	0
#define SPLIT_OUTPUT  TRUE	/*pdl: if TRUE output the DataTrain and 
							DataVal files when MAX_APPROX = 1. 
							If FALSE, do not output them at all*/

#define LEVEL_INPUTS POLY_DIM-1
#define NON_1_INPUTS POLY_TERMS-1

typedef double My_Real;

#define  Scale(x,m,b) (((m*x)+b) > 1.0 ? 1.0:\
		       ((m*x)+b) < -1.0 ? -1.0:\
		       ((m*x)+b))

struct Poly_defn
{
  unsigned int input_num[LEVEL_INPUTS];

  My_Real a[POLY_TERMS];
  My_Real scale_to_output;

  My_Real m_scale_out, b_scale_out;

  struct Poly_defn *np;
};

struct Cascade_Poly_defn
{
  unsigned int dim;

  unsigned int first_input;

  unsigned int num_of_levels;

  My_Real ave_value;

  My_Real *m_scale, *b_scale;
  
  struct Poly_defn *first_poly;
  My_Real *x_s;
};

typedef struct Poly_defn            Poly;
typedef struct Cascade_Poly_defn    Cascade_Poly;
