 /*---------------------------------------------------------------------------
| Filename: set_param.c
|
| Thomas Braunl   (braunl@ee.uwa.edu.au)
|
| Description: general utility function
|              to set integer or floating point parameter 
| ------------------------------------------------------------------------- */

#include "eyebot.h"

/***********************************************************************/
/** Set Floating Point Parameter over keyboard */
/** Parameters: text string description, min value, init value,
                max value, increment value */
/** Author:     Thomas Braunl, UWA 1998 */
/***********************************************************************/

float set_fparam(char text[], float minp, float start, float maxp, float inc)
{ float val;
  int   done = FALSE;

  LCDClear();
  LCDPrintf("Set Param\n%s\n", text);

  LCDMenu("+", "-", " ","OK");
  val = start;
  do
  { LCDSetPos(2,0);
    LCDPrintf("%f                    \n", val);
    switch(KEYGet())
    { case KEY1: if (val<maxp) val += inc; break;
      case KEY2: if (val>minp) val -= inc; break;
      case KEY4: done = TRUE;
    }
  } while (!done);
  LCDMenu(" ", " ", " "," ");
  return val;
}


/***********************************************************************/
/** Set Integer Parameter over keyboard */
/** Parameters: text string description, min value, init value,
                max value, increment value */
/** Author:     Thomas Braunl, UWA 1998 */
/***********************************************************************/

int set_iparam(char text[], int minp, int start, int maxp, int inc)
{ int val;
  int done = FALSE;

  LCDClear();
  LCDPrintf("Set Param\n%s\n", text);
  LCDMenu("+", "-", " ","OK");
  val = start;
  do
  { LCDSetPos(2,0);
    LCDPrintf("%d                    \n", val);
    switch(KEYGet())
    { case KEY1: if (val<maxp) val += inc; break;
      case KEY2: if (val>minp) val -= inc; break;
      case KEY4: done = TRUE;
    }
  } while (!done);
  LCDMenu(" ", " ", " "," ");
  return val;
}           


int main()
{ int   i;
  float f;

  /* example: set temperature,range [15..25],20 init,1 inc. */
  i = set_iparam("temp.", 15, 20, 25, 1);

  /* example: set noise ,range [0.1..0.9],0.7 init,0.1 inc. */
  f = set_fparam("temp.", 0.1, 0.7, 0.9, 0.1);

  return 0;
}


