/* **************************** */
/* Simple Multi-Tasking Example */
/* Thomas Braunl, UWA 2002      */
/* preeptive version            */
/* **************************** */
#include "eyebot.h"
#define SSIZE  4096
struct tcb *task1, *task2;
struct sem lcd;

void mytask()
{ int id, i;
  id = OSGetUID(0); /* read slave id no. */
  for (i=1; i<=100; i++)
  { OSSemP(&lcd);
      LCDPrintf("task %d : %d\n", id, i);
    OSSemV(&lcd);
  }
  OSKill(0);  /* terminate thread */
}

int main()
{ OSMTInit(PREEMPT);  /* init multitasking */
  OSSemInit(&lcd,1);  /* enable semaphore  */
  task1 = OSSpawn("t1", mytask, SSIZE, MIN_PRI, 1);
  task2 = OSSpawn("t2", mytask, SSIZE, MIN_PRI, 2);
  if(!task1 || !task2) OSPanic("spawn failed");

  OSReady(task1);  /* set state of task1 to READY */
  OSReady(task2);
  OSPermit();      /* start multitasking */
  OSReschedule();  /* switch to other process */
/* ---------------------------------------------------- */
  /* processing returns HERE, when no READY thread left */
  LCDPrintf("back to main");
  return 0;
};

