#ifndef _gui_h_
#define _gui_h_

#include "sim.h"

#include <qmainwindow.h>
#include <qlist.h>
#include <qlistview.h>
#include <qstring.h>
#include <qlabel.h>
#include <list>

class QConsole;
class RobiPosForm;
class SettingsForm;
class SoQtExaminerViewer;
class QAction;

class AppController : public QMainWindow
{
	Q_OBJECT

	list<QConsole*> consoles;
	const vector<LocalRobi*>& lrs;
	QListView* robiInfoList;
	RobiPosForm* robiPosForm;
	SettingsForm* settingsForm;
	SoQtExaminerViewer* viewer;
    QAction *openAction, *pauseAction, *quitAction, *stopAction,
		*modeAction, *robiPosFormAction;

	QString simulationFile;
	bool simStarted;
	bool simPaused;
	void updateActions();
	void start( QString fileName );
	void showEvent( QShowEvent* e );

public:
	AppController( QString simulationFile = QString::null );
	~AppController();

public slots:
		
	void doubleClickedOnRobi( QListViewItem* item );
	void robiSelectionChanged();
	void start();
	void pause( bool val );
	void stop();
	void mouseMode( bool selectMode );

	void changeRobiPosInteractively();
	void robiPosChanged( int );

	void settingsChanged( int );
	void st2rtrChanged( int );
};

class QSimulationTimeLabel : public QLabel
{
	Q_OBJECT;

public:
	QSimulationTimeLabel( QWidget* p );
	
public slots:
	void update();
};

#endif /* _gui_h_ */
