#include "console.h"
#include "console.moc"
#include "settings.h"
namespace robios {
#include "robios/keys.h"
};

#include <qtimer.h>
#include <qpainter.h>
#include <qimage.h>
#include <qfontmetrics.h>
#include <sstream>

static QTimer* theConsoleTimer = 0;

QConsole::QConsole( LocalRobi& r ) :
	font( "Courier", 20, QFont::Bold ), robi(r)
{
    setCaption( QString("Eyebot Console ") + QString::number(robi.id) );
    setBackgroundColor( white );

	QFontMetrics fm( font );
//	resize( 2*128, 3*64 );
    resize( fm.maxWidth() * (robi.lcd.textBuf.width()-1),
			fm.height() * robi.lcd.textBuf.height() );
	setFocusPolicy( QWidget::WheelFocus );
	
	screen_pm.resize( size() );
	image_pm.resize( size() );

//BUG: memory leak but therefore only one Timer for all consoles
	if( theConsoleTimer == 0 )
	{
		theConsoleTimer = new QTimer;
		theConsoleTimer->start( int(displayUpdateRate * 1000), FALSE );
	}
//	QTimer* t = new QTimer( this );
	connect( theConsoleTimer, SIGNAL(timeout()), SLOT(timer()) );
}

void QConsole::paintEvent( QPaintEvent* event )
{
	bitBlt( this, event->rect().topLeft(), &screen_pm, event->rect() );
}

void QConsole::resizeEvent( QResizeEvent * )
{
//    bgroup->move( width()-bgroup->width(), 0 );
}

void QConsole::timer()
{
	if( ! robi.lcd.dirtyImage && ! robi.lcd.dirtyText )
		return;

	if( robi.lcd.dirtyImage )
	{
		/* clear the pixmap with white */
		image_pm.fill();

		size_t w = robi.lcd.imageBuf.width(), h = robi.lcd.imageBuf.height();
//		size_t w = robi.lcd.roi.x, h = robi.lcd.roi.y;

		if( w != 0 && h != 0 )
		{
#ifndef PPM_HACK
			QImage image( w, h, 32 );
			for( size_t i = 0; i < h; ++i )
			{
				QRgb* d = (QRgb*)image.scanLine( i );
				uchar_triple* s = &robi.lcd.imageBuf( 0, i );
				for( size_t j = 0; j < w; ++j )
					d[j] = qRgb( s[j].r, s[j].g, s[j].b );
			}
#else
			/* this is kind of hacky but the only way to circumvent
			 * the necessity of creating a QImage and convert the image
			 * pixel by pixel. */
			ostringstream oss;
			oss << "P6" << endl << robi.lcd.imageBuf.width() << endl
				<< robi.lcd.imageBuf.height() << endl
				<< "255" << endl;
			string s = oss.str();
			QByteArray buf( robi.lcd.imageBuf.size_in_bytes() + s.size() );
			memcpy( buf.data(), s.c_str(), s.size() );
			memcpy( buf.data() + s.size(), robi.lcd.imageBuf.begin(),
					robi.lcd.imageBuf.size_in_bytes() );
			
			QImage image;
			if( ! image.loadFromData( buf ) )
				setCaption( "geht cin" );
			else
				setCaption( QString::number( image.width() ) );
#endif

			robi.lcd.dirtyImage = false;

			QPainter p( &image_pm );
			p.scale( (float)image_pm.width() / image.width(),
					 (float)image_pm.height() / image.height() );
			p.drawImage( 0, 0, image );
		}
	}

	screen_pm = image_pm;

	/* we draw the text anyway, because the image just overwrote it */
	QPainter p( &screen_pm );
	p.setFont( font );
//	p.setRasterOp( Qt::XorROP );
	p.drawText( screen_pm.rect(), 0, robi.lcd.text().c_str() );

	update();
}

void QConsole::keyPressEvent( QKeyEvent* e )
{
	int k = 0;
	switch( e->ascii() )
	{
	case '1' : k = robios::KEY1; break;
	case '2' : k = robios::KEY2; break;
	case '3' : k = robios::KEY3; break;
	case '4' : k = robios::KEY4; break;
	default : e->ignore();
	}

	if( k )
		robi.keyboard.keyDown( k );
}

void QConsole::keyReleaseEvent( QKeyEvent* e )
{
	int k = 0;
	switch( e->ascii() )
	{
	case '1' : k = robios::KEY1; break;
	case '2' : k = robios::KEY2; break;
	case '3' : k = robios::KEY3; break;
	case '4' : k = robios::KEY4; break;
	default : e->ignore();
	}

	if( k )
		robi.keyboard.keyUp();
}
