#ifndef _STRING_HELPERS_H_
#define _STRING_HELPERS_H_

#include <algorithm>
#include <functional>
#include <string>
#include <sstream>
#include <typeinfo>
#include <cctype>

#include "StringifiedException.h"

//BUG: this dummy was neccessary to get g++-3.0 running
inline int my_isspace( int x ) { using namespace std; return isspace( x ); }

/** This function simply erases heading and trailing white space. */
inline std::string trim( const std::string& h )
{
	using namespace std;
	/* this code searches the position of the first non whitespace char
	 * from front and back and copy the result */

	string::const_iterator b = find_if( h.begin(), h.end(),
		not1(ptr_fun(my_isspace)) );
	string::const_iterator e = find_if( h.rbegin(),
		reverse_iterator<string::const_iterator>(b),
			not1(ptr_fun(my_isspace)) ).base();

	return string( b, e );
}

DEF_EXCEPTION( EStringConversionError, StringifiedException )

/** This function just converts the given string to the template type T */
template<class T> inline T str_to( const std::string& s )
{
	T x;
	std::istringstream iss( s );
	iss.setf( std::ios::basefield );
	if( !(iss >> x) )
		throw EStringConversionError( EMsgE()
			<< "string conversion of '" << s << "' to type '"
			<< typeid(T).name() << "' failed.");
	return x;
}

template<> inline std::string str_to<std::string>( const std::string& s )
{
	return s;
}

/* these specializations has been necessary to support the conversion of +INF */
template<> inline double str_to<double>( const std::string& s )
{
	char* endptr;
	double d = strtod( s.c_str(), &endptr );
	if( *endptr != '\0' )
		throw EStringConversionError( EMsgE()
			<< "string conversion of '" << s << "' to type '"
			<< typeid(double).name() << "' failed.");
	return d;
}

template<> inline float str_to<float>( const std::string& s )
{
	char* endptr;
	double d = strtod( s.c_str(), &endptr );
	if( *endptr != '\0' )
		throw EStringConversionError( EMsgE()
			<< "string conversion of '" << s << "' to type '"
			<< typeid(float).name() << "' failed.");
	return d;
}

/** This function just converts the given value to a string by using the stream
 * operator<< .*/
template<class T> inline std::string to_str( const T& val )
{
	std::ostringstream oss;
#ifdef __WIN32__
	oss.setf( std::ios::boolalpha | std::ios::showbase );
#endif
	oss.precision(45); /* //BUG: it seams that precision 20 is the maximum used */
	if( !(oss << val) )
		throw EStringConversionError( EMsgE()
			<< "conversion of value '" << val << "' of type '"
			<< typeid(T).name() << "' to string failed.");
	return oss.str();
}

template<> inline std::string to_str<std::string>( const std::string& val )
{
	return val;
}

#endif /* _STRING_HELPERS_H_ */


