#ifndef _timer_h_
#define _timer_h_

#include <sys/time.h>

/*
#include <sys/resource.h>

class cputime
{
	rusage ru;

public:
	double operator()()
	{
		getrusage( RUSAGE_SELF, &ru );

		return (double)ru.ru_utime.tv_sec + 
			(double)ru.ru_utime.tv_usec/1000000.0;
	}
};
*/

#include <sys/times.h>
#include <unistd.h>

class cputime
{
	struct tms now;
	double clock_ticks_per_second;

public:
	cputime() : clock_ticks_per_second( sysconf(_SC_CLK_TCK) ) {}

	double operator()()
	{
		times( &now );
		return (double)now.tms_utime / clock_ticks_per_second;
	}
};

class realtime
{
	timeval tv;

public:
	double operator()()
	{
		gettimeofday( &tv, 0 );

		return (double)tv.tv_sec +  (double)tv.tv_usec/1000000.0;
	}
};

template<class TimeSource> class timer
{
	TimeSource ts;
	double t1, t2, sum, var_s;
	unsigned int n;
	bool running;

public:
	timer()
	{
		reset();
	}

	void start()
	{
		t1 = ts();
		running = true;
	}

	void stop()
	{
#ifdef DEBUG
		if( ! running )
			cout << "stopped not runnning timer\n";
#endif

		running = false;
		t2 = ts();

		n++;

		double elapsed = t2-t1;
		
/* 		if( elapsed > 0.0 ) */
/* 			cout << "elapsed: " << elapsed*1000.0 << endl; */
/* 		else */
/* 			cout << '.'; */

		sum   += elapsed;
		var_s += elapsed*elapsed;
	}

	double mean() const
	{
		return sum/(double)n;
	}

	double variance() const
	{
		double m = mean();
		return var_s/(double)n - m*m;
	}

	void reset()
	{
		t1 = t2 = sum = var_s = 0.0;
		n = 0;
		running = false;
	}

	double elapsed() { return (running ? ts() : t2) - t1; }
};

#endif /* _timer_h_ */
