#include "parser.h"

#include <fstream>
#include "libutil/string_helpers.h"
#include "libutil/StringifiedException.h"

void parseConfigurationFile( const char* fileName, Configuration& config,
							 const std::string& commentChars )
{
	ifstream f( fileName );
	if( ! f )
		throw EIosFailure( EMsgE() << "can not open file '" << fileName << "'" );

	while( ! f.eof() )
	{
		string s;
		getline( f, s );
		s = trim( s );
		if( s.empty() || commentChars.find( s[0] ) != std::string::npos )
			continue;

		for( Configuration::iterator i = config.begin();
			 i != config.end(); ++i )
		{
			if( starts_with( s, i->first ) )
			{
				i->second = trim( s );
				/* break the for loop to continue with the while loop */
				break;
			}
		}
	}
}

