#include "eyebot.h"
#include "thread_adapter.h"
#include "settings.h"
#include "inventor.h"
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoPerspectiveCamera.h>
#include <Inventor/SoOffscreenRenderer.h>

#define ENTER_ROBIOS_CAM \
	ENTER_ROBIOS; \

#define ENTER_ROBIOS_CAM_INIT \
	ENTER_ROBIOS_CAM; \
	if( robi.cameras.empty() || ! robi.cameras[0].initialized() ) \
		return -1;

void Camera::init()
{
	camera = new SoPerspectiveCamera;
	camera->nearDistance.setValue(0.01);
	camera->farDistance.setValue(10.0);
	root = new SoSeparator;
	root->ref();
	root->addChild( camera );
	root->addChild( theSceneGraph.root() );

	SbViewportRegion vpr( imagecolumns, imagerows );
	renderer = new SoOffscreenRenderer( vpr );
	renderer->setComponents( SoOffscreenRenderer::RGB );
	renderer->setBackgroundColor(
		SbColor(backgroundColor.r, backgroundColor.g, backgroundColor.b) );
}

void Camera::release()
{
	if( root )
	{
		root->unref();
		root = 0;
		camera = 0;
		delete renderer;
	}
}

bool Camera::render( colimage* buf )
{
	if( ! renderer->render( root ) )
		return false;

	/* aparently the buffer is organized "upside down", so we have to 
	 * flip it verticaly */
	for( size_t r = 0; r < imagerows; ++r )
		memcpy( ((char*)(*buf))+r*imagecolumns*3,
				renderer->getBuffer() + imagecolumns*3*(imagerows-1)
				- r*imagecolumns*3,
				imagecolumns*3 );
//	memcpy( *buf, renderer->getBuffer(), imagecolumns*imagerows*3 );

	return true;
}

void Camera::updatePos( const Position& robiPos )
{
	double_pointxy cur_pos = robiPos + rotate( relPos, robiPos.phi );
	double cur_phi = pan + robiPos.phi + relPan;
	double cur_theta = tilt + relTilt;
	camera->position.setValue( pointxy2SbVec3f( cur_pos, relPosZ ) );
	camera->pointAt(
		pointxy2SbVec3f(
			cur_pos + rotate(double_pointxy(std::cos(cur_theta),0), cur_phi),
			relPosZ + sin(cur_theta) ),
		SbVec3f(0,0,1) );
}

namespace robios {

int CAMInit(int zoom)
{
	ENTER_ROBIOS_CAM;
	if( robi.cameras.empty() )
		return 255;

	if( robi.cameras[0].initialized() )
		return 254;
	robi.cameras[0].init();

	return 16;
}

int CAMRelease()
{
	ENTER_ROBIOS_CAM_INIT;
	robi.cameras[0].release();
	return 0;
}

int CAMGetFrame(image* buf)
{
	ENTER_ROBIOS_CAM_INIT;
	return 0;
}

int CAMGetColFrame(colimage* buf, int convert)
{
	ENTER_ROBIOS_CAM_INIT;

	robi.cameras[0].updatePos(theWorld.robis[robi.id].pos);
	if( ! robi.cameras[0].render( buf ) )
		return -1;

	return 0;
}

int CAMSet(int bright, int para1, int para2 )
{
	ENTER_ROBIOS_CAM_INIT;
	return 0;
}

int CAMGet(int *bright, int *offsetORhue, int *contrastORsaturation)
{
	ENTER_ROBIOS_CAM_INIT;
	return 0;
}

int CAMMode(int mode)
{
	ENTER_ROBIOS_CAM_INIT;
	return 0;
}

int SIM_CAMSetPanTiltAnlge( radians pan, radians tilt )
{
	ENTER_ROBIOS_CAM_INIT;
	robi.cameras[0].pan = pan;
	robi.cameras[0].tilt = tilt;
	return 0;
}

int SIM_SetKicker( float parallelRef, float perpendicularRef, float speed )
{
	ENTER_ROBIOS;
	theCoreAdapter.setKicker(
		double_pointxy( parallelRef, perpendicularRef ), speed );
	return 0;
}

} /* namespace robios */
