#include "eyebot.h"
#include "sim.h"

#define UNIMPLEMENTED_ROBIOS_FUNCTION \

#define ROBIOS_STUB \
	ENTER_ROBIOS;\
	dbg_msg( "robi " << robi.id << " called unimplemented RoBiOS function '" \
			 << __func__ << "'" << endl ); \
	return 0;

#define ROBIOS_STUB_VOID \
	ENTER_ROBIOS;\
	dbg_msg( "robi " << robi.id << " called unimplemented RoBiOS function '" \
			 << __func__ << "'" << endl ); \

namespace robios {

/* this is a test function, used during the implementation of the
 * simulator */
int function( int n )
{
	LocalRobi& robi = LocalRobi::thisRobi();
	robi.enter();

	// do something
	robi.virtualTime += (double)n * LocalThread::timeSlice;

	robi.leave();
	return 1;
}

int OSEnable() { ROBIOS_STUB }
int OSDisable() { ROBIOS_STUB }
int OSGetVar(int num) { ROBIOS_STUB }
int OSPutVar(int num, int val) { ROBIOS_STUB }

int AUPlaySample(char* sample) { ROBIOS_STUB }
int AUCheckSample() { ROBIOS_STUB }
int AURecordSample(BYTE* buf, long len, long freq) { ROBIOS_STUB }
int AUCheckRecord() { ROBIOS_STUB }
int AUTone(int , int ) { ROBIOS_STUB }
int AUBeep() { ROBIOS_STUB }
int AUCaptureMic() { ROBIOS_STUB }
int AUCheckTone() { ROBIOS_STUB }

ServoHandle SERVOInit(DeviceSemantics semantics) { ROBIOS_STUB }
int SERVORelease(ServoHandle handle) { ROBIOS_STUB }
int SERVOSet(ServoHandle handle,int angle) { ROBIOS_STUB }

MotorHandle MOTORInit(DeviceSemantics semantics) { ROBIOS_STUB }
int MOTORRelease(MotorHandle handle) { ROBIOS_STUB }
int MOTORDrive(MotorHandle handle,int speed) { ROBIOS_STUB }

QuadHandle QuadInit(DeviceSemantics semantics) { ROBIOS_STUB }
int QuadRelease(QuadHandle handle) { ROBIOS_STUB }
int QuadReset(QuadHandle handle) { ROBIOS_STUB }
int QuadRead(QuadHandle handle) { ROBIOS_STUB }
DeviceSemantics QUADGetMotor(DeviceSemantics semantics) { ROBIOS_STUB }
float QUADODORead(QuadHandle handle) { ROBIOS_STUB }
int QUADODOReset(QuadHandle handle) { ROBIOS_STUB }

BumpHandle BUMPInit(DeviceSemantics) { ROBIOS_STUB }
int BUMPRelease(BumpHandle) { ROBIOS_STUB }
int BUMPCheck(BumpHandle , int *) { ROBIOS_STUB }

IRHandle IRInit(DeviceSemantics) { ROBIOS_STUB }
int IRRelease(IRHandle) { ROBIOS_STUB }
int IRRead(IRHandle) { ROBIOS_STUB }

BYTE OSReadInLatch(int latchnr) { ROBIOS_STUB }
BYTE OSWriteOutLatch(int latchnr, BYTE mask, BYTE value) { ROBIOS_STUB }
BYTE OSReadOutLatch(int latchnr) { ROBIOS_STUB }
BYTE OSReadParData() { ROBIOS_STUB }
void OSWriteParData(BYTE value) { ROBIOS_STUB_VOID }
BYTE OSReadParSR() { ROBIOS_STUB }
void OSWriteParCTRL(BYTE value) { ROBIOS_STUB_VOID }
BYTE OSReadParCTRL() { ROBIOS_STUB }

int OSGetAD(int) { ROBIOS_STUB }
int OSOffAD(int mode) { ROBIOS_STUB }

int COMPASSCalibrate(int mode) { ROBIOS_STUB }
int COMPASSCheck(void) { ROBIOS_STUB }
int COMPASSGet(void) { ROBIOS_STUB }
int COMPASSInit(DeviceSemantics semantics) { ROBIOS_STUB }
int COMPASSRelease(void) { ROBIOS_STUB }
int COMPASSStart(BOOL cycle) { ROBIOS_STUB }
int COMPASSStop(void) { ROBIOS_STUB }

} /* namespace robios */
