#ifndef _thread_adapter_h_
#define _thread_adapter_h_

#include <cc++/thread.h>
#include <cc++/file.h>
#include "sim.h"

class CoreThreadAdapter : public CoreInterface, public ResponseInterface
{
public:
	void setVWController( const VWData& vwData );
	void synchronize( const Time& time );
	void setKicker( const double_pointxy& reflectionCoefficients, double speed );

	const Robi& startRobi( const char* executable, id_t id );
	void cleanup();
	void respond( id_t id );
	void registerThread( id_t id );

	void sendRADIOMessage( const RADIOMessage& message );
	void deliverRADIOMessage( id_t id, const RADIOMessage& message );
	void reportCollision( id_t id, const Time& time );
};

class RobiThread : public ost::Thread
{
	ost::DSO dso;
	int (*main)();
	id_t id;

public:
	RobiThread( const char* executable, id_t id ) :
		Thread(), dso( const_cast<char*>(executable) ), id( id )
	{
		main = (int(*)())(dso["main"]);
	}

	void Run();
	void Final();
	void Terminate() { ost::Thread::Terminate(); }
};

extern CoreThreadAdapter theCoreAdapter;
extern Core theCore;

/* this is currently the way for the gui to get direct access to the
 * LocalRobi structures for displaying purposes. In distributet
 * implementation, it would be neccessary, to find another way, since
 * there would be no global accessable location of this information. */
const vector<LocalRobi*>& theLocalRobis();

#endif /* _thread_adapter_h_ */
