/** @author Peter Vanopulos
    @date 29/11/99
    @filename wall.c
    @memo
	The purpose of this file is to make the robot drive along a wall.
	Instead of sensing the wall is now very close and abruptly turning\
	the objective is to turn the robot smothly.
*/

#include "eyebot.h"

#define v_lin 7.0
#define t_lin 0.3
#define v_rot 10.0
#define t_rot 0.1   
#define limit 5		
const float PI = 3.141596;

/* function prototypes */


int main ()
{
	/* global variables */
	PSDHandle       psd_front, psd_left, psd_right;
	VWHandle        vw;

	int new_left, new_front;
	int wall_distance;
	float speed = 0.2;

	/* clear display and write message */
	LCDMode(SCROLLING|NOCURSOR);
	LCDMenu("","","","END");

	LCDPutString("Roll on ...\n");
	vw=VWInit(VW_DRIVE,1); /* parameter for scale i.e. 100Hz*/			
	VWStartControl(vw, v_lin, t_lin , v_rot, t_rot);
	
	/* initialise the PSD's */
	psd_front = PSDInit(PSD_FRONT);
	psd_left = PSDInit(PSD_LEFT);
	psd_right = PSDInit(PSD_RIGHT);
	PSDStart(psd_front|psd_left|psd_right, TRUE);
	
	wall_distance = PSDGet(psd_left);

	LCDPrintf("wall dist: %d\n", wall_distance);

//  while(KEYRead() != KEY4)    /* loop until the end button is hit */
	while(1)
	{
		new_left = PSDGet(psd_left);
		new_front = PSDGet(psd_front);
		
		if( new_front > wall_distance )
		{
			int d = new_left - wall_distance;
			VWSetSpeed(vw, speed, PI/200.0 * d );
		}
		/* otherwise we need to make a turn */
		else 
		{
			/* turn the corner right */
			VWDriveTurn(vw, -PI/2.0, 1 );
			LCDPutString("Turning Right...");
			VWDriveWait(vw);
			LCDPutString(" ready.\n");
		}  
		
		OSWait(10); /* wait for 10/100 s. -- do not new calc. pos. if not moved */
	}
    
	LCDPutString("END Button pressed\n");
	VWRelease(vw);
	PSDRelease();
	return 0;
}

