OUTPUT_ARCH (m68k)
OUTPUT_FORMAT (srec)

MEMORY
{
  ram (rwx) : ORIGIN = 0xc1c000, LENGTH = 16K
}

/*
 * stick everything in ram (of course)
 */
SECTIONS
{
  .text :
  {
    *(.text)
    . = ALIGN(0x4);
  } > ram

  .data :
  {
    *(.data)
    _edata = .;
  } > ram

  .bss :
  {
    . = ALIGN(0x4);
    __bss_start = . ;
    *(.shbss)
    *(.bss)
    *(COMMON)
    _end =  ALIGN (0x8);
    __end = _end;
  } > ram

  .stab 0 (NOLOAD) :
  {
    *(.stab)
  }

  .stabstr 0 (NOLOAD) :
  {
    *(.stabstr)
  }
}
