@echo off

if exist %1.c goto compile
goto error

:compile
echo --compiling HDT file: '%1.c'
gcc -m68332 -I%gcc%\m68k\include -I%mc%\include -ansi -pedantic -c -msoft-float %1.c

echo --linking
ld -T%mc%\ldfiles\robi-hdt.ld -L%mc%\lib -o %1.l %1.o -lmym -lmyc -lmygcc -lrobi -limpro

echo --object-copy
objcopy -O srec %1.l %1.hex

echo --compressing '%1.hex'
srec2bin %1.hex >NUL

if exist %1.o del %1.o
if exist %1.l del %1.l
goto end

:error
echo Error: file '%1.c' not found!

:end
@echo on
