STARTUP(sfxboot.o)
OUTPUT_FORMAT("coff-m68k")
OUTPUT_ARCH(m68k)
SEARCH_DIR(.)
/*
 * Setup the memory map for Robios
 * using the whole lower 128k of rom/ram
 * stack grows down from high memory.
 *
 * The memory map look like this:
 * +--------------------+ <- low memory
 * | .text              |
 * |        _etext      |
 * |        ctor list   | the ctor and dtor lists are for
 * |        dtor list   | C++ support
 * +--------------------+
 * | .data              | initialized data goes here
 * |        _edata      |
 * +--------------------+
 * | .bss               |
 * |        __bss_start | start of bss, cleared by crt0
 * |        _end        | start of heap, used by sbrk()
 * +--------------------+
 * .                    .
 * .                    .
 * .                    .
 * |        __stack     | top of stack
 * +--------------------+
 */

MEMORY
{
  ram     : ORIGIN = 0x000000,  LENGTH = 128K
}

/*
 * stick everything in ram (of course)
 */
SECTIONS
{
  .text :
  {
    *(.text)
    _etext = .;
  } > ram

  .shbss SIZEOF(.text) + ADDR(.text) :
  {
    *(.shbss)
  } > ram

  .data :
  {
    *(.data)
    _edata = .;
  } > ram

  .bss SIZEOF(.data) + ADDR(.data) :
  {
    __bss_start = ALIGN(0);
    *(.bss)
    *(COMMON)
    _end = ALIGN(0);
    __end = ALIGN(0);
  } > ram

  .stab . (NOLOAD) :
  {
    [ .stab ]
  }

  .stabstr . (NOLOAD) :
  {
    [ .stabstr ]
  }
}
