/*
| -----------------------------------------------------------------------------
| Filename: hdtsocc.c
|
| Author:       Thomas Braunl   (braunl@ee.uwa.edu.au)
|               Klaus Schmitt   (kschmitt@informatik.uni-kl.de)
|               Thomas Lampart  (lamparts@autolife.informatik.uni-stuttgart.de)
| Description:
| -------
| HDT data for EyeBot MK3, UWA Sep. 1998, modified for soccerbot
| -----------------------------------------------------------------------------
*/

#define VERSION 1.1           /* User specific version nr. for information */
#define NAME "Jamie"        /* Unique name of the platform max. 10 chars, just for information */
#define ID   3                /* Unique platform id (int), just for inform. */

#include "hdt.h"
#include "hdt_sem.h"

/* The HDT structure */
/*-------------------*/
int     magic = 123456789;
extern HDT_entry_type HDT[];
HDT_entry_type  *hdtbase = &HDT[0];

#include "types.h"
#include "const.h"
#include "rs232.h"
#include "cam.h"
#include "librobi/librobi.h"

/*
 * PSD-sensor #1 (Front), range 79 - 367 mm
 * wall = white wall of soccer field (different for other obstacles)
 */
short distfront[128] =
  { 79,79,79,79,79,79,79,79,79,81,           /*   1 -  20 */
    83,84,86,87,88,89,90,92,93,94,           /*  21 -  40 */
    95,96,97,100,101,102,103,104,106,108,    /*  41 -  60 */
    109,110,111,112,114,116,119,120,122,124, /*  61 -  80 */
    126,128,130,133,134,136,137,142,143,144, /*  81 - 100 */
    147,151,152,154,155,160,163,168,169,176, /* 101 - 120 */
    176,180,186,188,192,196,201,209,209,223, /* 121 - 140 */
    223,229,237,237,244,250,260,266,266,274, /* 141 - 160 */
    281,285,291,307,305,321,325,335,339,371, /* 161 - 180 */
    367,9999,9999,9999,9999,9999,9999,9999,9999,9999, /* 181 - 200 */
    9999,9999,9999,9999,9999,9999,9999,9999,9999,9999, /* 201 - 220 */
    9999,9999,9999,9999,9999,9999,9999,9999,9999,9999, /* 221 - 240 */
    9999,9999,9999,9999,9999,9999,9999,9999};        /* 241 - 256 */

/* PSD-sensor #0 (R3P0-L), range 60 - 690 mm */
short distleft[128] =
  { 60,60,60,60,60,60,60,60,60,60, /* 1 - 20 */
    60,60,60,60,61,63,65,67,69,70, /* 21 - 40 */
    72,73,75,76,77,79,80,82,83,84, /* 41 - 60 */
    86,87,89,90,92,93,95,96,98,100, /* 61 - 80 */
    101,103,105,106,108,109,111,113,115,117, /* 81 - 100 */
    119,122,124,126,128,131,134,137,140,142, /* 101 - 120 */
    145,148,151,154,158,161,165,170,174,178, /* 121 - 140 */
    182,187,192,200,206,213,220,226,233,246, /* 141 - 160 */
    253,266,273,290,310,310,350,350,390,390, /* 161 - 180 */
    430,430,490,470,550,530,610,590,690,9999, /* 181 - 200 */
    9999,9999,9999,9999,9999,9999,9999,9999,9999,9999, /* 201 - 220 */
    9999,9999,9999,9999,9999,9999,9999,9999,9999,9999, /* 221 - 240 */
    9999,9999,9999,9999,9999,9999,9999,9999}; /* 241 - 256 */

/* PSD-sensor #2 (R3P2-R), range 60 - 605 mm */
short distright[128] =
  { 60,60,60,60,60,60,60,60,60,60, /* 1 - 20 */
    60,60,60,60,62,64,66,68,71,72, /* 21 - 40 */
    74,75,77,79,80,82,84,86,88,90, /* 41 - 60 */
    91,93,95,97,99,100,103,105,107,110, /* 61 - 80 */
    112,114,116,118,121,124,127,130,132,135, /* 81 - 100 */
    138,141,144,148,151,155,158,161,165,170, /* 101 - 120 */
    175,180,185,190,195,200,210,215,222,235, /* 121 - 140 */
    240,250,262,275,287,301,315,335,360,372, /* 141 - 160 */
    385,395,415,432,453,464,495,520,543,563, /* 161 - 180 */
    605,9999,9999,9999,9999,9999,9999,9999,9999,9999, /* 181 - 200 */
    9999,9999,9999,9999,9999,9999,9999,9999,9999,9999, /* 201 - 220 */
    9999,9999,9999,9999,9999,9999,9999,9999,9999,9999, /* 221 - 240 */
    9999,9999,9999,9999,9999,9999,9999,9999}; /* 241 - 256 */

BYTE motconv0[101]= { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15,16,17,18,19,
                     20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,
                     40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,
                     60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,
                     80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,
                     100};

/* DC motors */
motor_type motor0 = {2,  1, TIMER1, 8191, (void*)OutBase, 3, 2, (BYTE*)&motconv0};
motor_type motor1 = {2,  0, TIMER1, 8191, (void*)OutBase, 0, 1, (BYTE*)&motconv0};
quad_type decoder0 = {0, 2, 3, MOTOR_LEFT,  3235, 2.0};
quad_type decoder1 = {0, 5, 4, MOTOR_RIGHT, 3235, 2.0};
vw_type drive = {0, DIFFERENTIAL_DRIVE, {QUAD_LEFT, QUAD_RIGHT, 0.084}};


/* SERVOs */
/* type, TPU-channel, Timer2, 20ms period, 0.7ms min, 1.7ms max */
/* here: servo 1 has TPU channel 2, and so on                   */
servo_type servo11 = {2, 12, TIMER2, 20000, 1900, 1280}; /* camera */
servo_type servo12 = {2, 13, TIMER2, 20000, 1550, 1350}; /* kicker */


/* PSD-infrared */
psd_type   psdleft   = {0, 14, (BYTE*)InBase, 0, AH, (BYTE*)OutBase, 4, AH, (short*)&distleft};
psd_type psdfront = {0, 14, (BYTE*)InBase, 1, AH, (BYTE*)OutBase, 4, AH, (short*)&distfront};
psd_type   psdright   = {0, 14, (BYTE*)InBase, 2, AH, (BYTE*)OutBase, 4, AH, (short*)&distright};


/* EyeBot SUMMARY */
info_type roboinfo  = {0,PLATFORM,SER115200,RTSCTS,SERIAL1,0,0,AUTOBRIGHTNESS,BATTERY_ON,35,VERSION,NAME,ID};

/* waitstates = 0..13, Fast Termination = 14, External = 15 */
/* Version, ROM, RAM, LCD, IO, Parallel+Serial2/3 */
/* 16MHz - 20Mhz */
/* waitstate_type waitstates = {0,3,0,1,0,2}; */
/* 21MHz - 41Mhz */
waitstate_type waitstates = {0,3,1,2,1,2};

/* this is a test HDT structure which contains ALL EyeBot hardware devices */

HDT_entry_type HDT[] =
{
    {MOTOR,MOTOR_RIGHT,"RIGHT",(void *)&motor0},
    {MOTOR,MOTOR_LEFT,"LEFT",(void *)&motor1},
    {QUAD, QUAD_RIGHT,"RIGHT",(void *)&decoder1},
    {QUAD, QUAD_LEFT,"LEFT",(void *)&decoder0},
    {VW,VW,"Drive",(void *)&drive},

    /* {BUMP, BUMP_LEFT,"LEFT",(void *)&bumper0}, */
    /* {IR, IR_LF,"LF",(void *)&ir0},             */

    {SERVO,SERVO11,"S11-C",(void *)&servo11},
    {SERVO,SERVO12,"S12-K",(void *)&servo12},

    {PSD,PSD_LEFT,      "P0-L", (void *)&psdleft},
    {PSD,PSD_FRONT,     "P1-F", (void *)&psdfront},
    {PSD,PSD_RIGHT,     "P2-R", (void *)&psdright},

    {WAIT,WAIT,"WAIT",(void *)&waitstates},
    {INFO,INFO,"INFO",(void *)&roboinfo},

    {END_OF_HDT,UNKNOWN_SEMANTICS,"END",(void *)0}
};

