/*
| ---------------------------------------------------------------------------------
| Filename: hdtempty.c
|
| Author:       Thomas Lampart  (lamparts@autolife.informatik.uni-stuttgart.de)
|               Klaus Schmitt   (kschmitt@informatik.uni-kl.de)
| Description: 
| -------
| HDT data for a 'naked' Eyebot
| ---------------------------------------------------------------------------------
*/
#define VERSION 1.11
#define NAME "Empty"            /* Unique name of the platform max. 10 chars, just for information */
#define ID   1                  /* Unique platform id (unsigned char) */

#include "hdt.h"
#include "hdt_sem.h"

/* The HDT structure */
/*-------------------*/
int     magic = 123456789;
extern HDT_entry_type HDT[];
HDT_entry_type  *hdtbase = &HDT[0];

#include "types.h"
#include "const.h"
#include "rs232.h"
#include "cam.h"
#include "librobi/librobi.h"

info_type roboinfo = {0,PLATFORM,SER115200,RTSCTS,SERIAL1,0,OFF,AUTOBRIGHTNESS,BATTERY_OFF,33,VERSION,NAME,ID};

/* waitstates = 0..13, Fast Termination = 14, External = 15 */
/* Version, ROM, RAM, LCD, IO, Parallel+Serial2/3 */
/* 16MHz - 20Mhz */
/* waitstate_type waitstates = {0,3,0,1,0,2}; */
/* 21MHz - 41Mhz */
waitstate_type waitstates = {0,3,1,2,1,2};

/* HDT for Eyebot Vehicle                         */

#include <startup.h>

HDT_entry_type HDT[] =
{

    {WAIT,WAIT,"WAIT",(void *)&waitstates},
    {INFO,INFO,"INFO",(void *)&roboinfo},
    {STARTIMAGE,STARTIMAGE,"Image",(void *)&startimage},

    {END_OF_HDT,UNKNOWN_SEMANTICS,"END",(void *)0}
};
