/********************************************************
| File:         irtv.h
|
| Author:       Michael Kapp
|
| Changed:      06-Apr-00
|
| Description:  IR remote control support
*********************************************************/


#ifndef IRTV_H
#define IRTV_H


/* Code types */

#define RAW_CODE            0               /* normally only used by the analyzer */
#define SPACE_CODE          1
#define PULSE_CODE          2
#define MANCHESTER_CODE     3


/* Modes */

#define DEFAULT_MODE        0
#define SLOPPY_MODE         1
#define REPCODE_MODE        2


/* internal use */
#define PULSE 0                             /* "state" values */
#define SPACE 1

#define START_TTL 20                        /* default "time to live" value (1/100 sec) */

#endif
