/*
* simregs.s - define addresses of SIM registers in 68331/332
* adjust the setting of simmcr to reflect modmap bit
*/

simmcr  =     0xfffffa00      | sim module configuratio register
simtr   =     simmcr+2       | sim test register
syncr   =     simmcr+4       | clock synthesizer control
rsr     =     simmcr+7       | reset status register
simtre  =     simmcr+8       | sim module test e
porte   =     simmcr+0x11     | port e data register
ddre    =     simmcr+0x15     | port e data direction register
pepar   =     simmcr+0x17     | port e pin assignment register
portf   =     simmcr+0x19     | port f data register
ddrf    =     simmcr+0x1d     | port f data direction register
pfpar   =     simmcr+0x1f     | port f pin assignment register
sypcr   =     simmcr+0x21     | system protection control
picr    =     simmcr+0x22     | periodic interrupt control
pitr    =     simmcr+0x24     | periodic interrupt timer
swsr    =     simmcr+0x27     | watchdog software service register
tstmsra =     simmcr+0x30     | test master shift register a
tstmsrb =     simmcr+0x32     | test master shift register b
tstsc   =     simmcr+0x34     | test shift count register
tstrc   =     simmcr+0x36     | test repetition count register
creg    =     simmcr+0x38     | test module control
dreg    =     simmcr+0x3a     | test distributed control
portc   =     simmcr+0x41     | port c data register
cspar0  =     simmcr+0x44     | chip select pin assignment register 0
cspar1  =     simmcr+0x46     | chip select pin assignment register 1
csbarbt =     simmcr+0x48     | CSBOOT base address register
csorbt  =     simmcr+0x4a     | CSBOOT option register
csbar0  =     simmcr+0x4c     | chip select 0 base address register
csor0   =     simmcr+0x4e     | chip select 0 option register
csbar1  =     simmcr+0x50     | chip select 0 base address register
csor1   =     simmcr+0x52     | chip select 0 option register
csbar2  =     simmcr+0x54     | chip select 0 base address register
csor2   =     simmcr+0x56     | chip select 0 option register
csbar3  =     simmcr+0x58     | chip select 0 base address register
csor3   =     simmcr+0x5a     | chip select 0 option register
csbar4  =     simmcr+0x5c     | chip select 0 base address register
csor4   =     simmcr+0x5e     | chip select 0 option register
csbar5  =     simmcr+0x60     | chip select 0 base address register
csor5   =     simmcr+0x62     | chip select 0 option register
csbar6  =     simmcr+0x64     | chip select 0 base address register
csor6   =     simmcr+0x66     | chip select 0 option register
csbar7  =     simmcr+0x68     | chip select 0 base address register
csor7   =     simmcr+0x6a     | chip select 0 option register
csbar8  =     simmcr+0x6c     | chip select 0 base address register
csor8   =     simmcr+0x6e     | chip select 0 option register
csbar9  =     simmcr+0x70     | chip select 0 base address register
csor9   =     simmcr+0x72     | chip select 0 option register
csbar10 =     simmcr+0x74     | chip select 0 base address register
csor10  =     simmcr+0x76     | chip select 0 option register

