/* ----------------------------------------------------------------- */

/* 'ZFeetClass.h'										    */

/* Centre of Gravity Calculating- Header- File			         */

/* 													    */

/* 	last modified 07/04/2003								    */

/* 	see ZFeetClass.cc for implementations					    */

/* 													    */

/* 													    */

/* 													    */

/* 													    */

/* 	(C) Jochen Zimmermann								    */

/* ----------------------------------------------------------------- */



//avoid redefinition during static binding

#ifndef ZFEETCLASS

#define ZFEETCLASS



#include "ZHeaders.h"

/*

//needed headers, included via ZHeaders.h

#include "ZInfraRed.h"

*/







//Painting parameters

#define TOEMEAN  1.558

/*mean of toes, not further needed*/



// left foot:trigonometric values evoked by the angles of the toes

#define COST1 -0.342

#define SINT1  0.940

#define COST2 -0.342

#define SINT2 -0.940

#define COST3  1.000

#define SINT3  0.000

// right foot:trigonometric values evoked by the angles of the toes

#define COST4  0.342

#define SINT4  0.940

#define COST5 -1.000

#define SINT5  0.000

#define COST6  0.342

#define SINT6 -0.940

// Values to correct the sensitiveness of each strain gage 

// (by 19/12/2002) meausred with bottle ;-) and bottle train

#define CORT1 1.125

#define CORT2 1.012

#define CORT3 0.908

#define CORT4 0.866

#define CORT5 1.095

#define CORT6 1.048





class Feet

{

    public:

    

	static Feet* GetTheInstance();

	/*instance retriever*/

	

	bool Init();

	/*initialises members. It is essential that the robot is not

	standing on his feet while calling this function*/

	

	LinearAlgebra 	GetCOG(LinearAlgebra& buf, int left=1,bool refresh=false);

	/*returns inside-calculated centre of force of one foot*/

	

	bool GetCOG(double* buf);

	/*returns inside-calculated centre of force of one foot*/

	

	bool LoadDistribution(double *left,double *right,double *total,bool refresh=true);

	/*returns inside-calculated force-distribution among feet*/

	

	int  Lifted(bool refresh=false);

	/*returns wether a foot is attached to the ground or lifted*/

	

	int   deadbandwidth;

	/*specifies a deadbandwidth under which no read differences are considered*/

	

	int	 readings;

	/*specifies a time for validating the data capture, depends on ADC*/

     

		

    private:

	

	void Read();

	/*reads all 6 A/D- channels at a time to internal buffer*/

	

     void ZeroMemory (BYTE *array, int bytesize);

     /*empties a specified array*/

     

     void RefreshCOG();

     /*forces new read and cog calculation*/

     

     

     float cognew[4];

     /*new cog coordinates*/

     

     int   feetdatalifted[6];

     /*read initialisation data*/

     

     int   feetdata[6];

     /*last read data*/

     

     int   oldfeetdata[6];

     /*last but one read data*/

     

     float toes[6];

     /*interbuffer for calculation and amplification correction*/

     

     int   liftsensitivity;

     /*sensitivity above which a foot is considered lifted*/

     

     

	Feet();

	/*standard constructor for initialisations*/

	

	static Feet SingleInstance;

	/*The SingleInstance of this Class*/

	

};







#endif

