/*
 * Author: Mari Wang <mariw@tartarus.uwa.edu.au>
 * Date: 1999-11-27
 *
 * Test speed of RoBIOS functions.
 */

#include <eyebot.h>
#include <stdio.h>
#include "../timerheader.h"

int
main(int argc, char *argv[])
{
  char *function_type = "OS functions"; /* Fill in adequate name of
                                         * functions currently being
                                         * tested */

  /* File specific variables (those needed for testing */

  int k;

  index += init_test(function_type);

  k = OSGetVar(SYSSAVEVAR7); /* use SYSSAVEVAR7 - location of speed of
			      * SERIAL communication */

  /* Functions to be tested go here.
   * Semantics:
   * do_test(function_name, parameters);
   */
  do_test(OSMachineType,());
  do_test(OSMachineSpeed,());
  do_test(OSMachineName,());
  do_test(OSMachineID,());
  do_test(OSEnable,());
  do_test(OSGetVar,(SYSSAVEVAR7));
  do_test(OSPutVar,(SYSSAVEVAR7, k));
  
  end_test();

  return 0;
}
