//## begin module%1.4%.codegen_version preserve=yes
//   Read the documentation to learn more about C++ code generator
//   versioning.
//## end module%1.4%.codegen_version

//## begin module%3D883FDA01E0.cm preserve=no
//	  %X% %Q% %Z% %W%
//## end module%3D883FDA01E0.cm

//## begin module%3D883FDA01E0.cp preserve=no
//## end module%3D883FDA01E0.cp

//## Module: ImageFilter%3D883FDA01E0; Pseudo Package specification
//## Source file: C:\Program Files\Rational\Rose\C++\source\ImageFilter.h

#ifndef ImageFilter_h
#define ImageFilter_h 1

//## begin module%3D883FDA01E0.additionalIncludes preserve=no
//## end module%3D883FDA01E0.additionalIncludes

//## begin module%3D883FDA01E0.includes preserve=yes
#include "eyebot.h"
//## end module%3D883FDA01E0.includes

//## begin module%3D883FDA01E0.additionalDeclarations preserve=yes
//## end module%3D883FDA01E0.additionalDeclarations


//## begin ImageFilter%3D883FDA01E0.preface preserve=yes
//## end ImageFilter%3D883FDA01E0.preface

//## Class: ImageFilter%3D883FDA01E0
//	/**
//	This class provides image filters.
//	@author Jia L. Du
//	 */
//## Category: <Top Level>
//## Persistence: Transient
//## Cardinality/Multiplicity: n



class ImageFilter
{
  //## begin ImageFilter%3D883FDA01E0.initialDeclarations preserve=yes
  //## end ImageFilter%3D883FDA01E0.initialDeclarations

  public:
    //## Constructors (generated)
      ImageFilter();


    //## Other Operations (specified)
      //## Operation: sobelFilter%3D9028C90190
      //	/**
      //	Applies the sobel (edge detection) filter to the source
      //	image. The source image is not modified
      //	@param source The source image
      //	@param destination A reference to the new, filtered image
      //	 */
      void sobelFilter (image& source, image& destination);

      //## Operation: color2Grey%3D90290E033E
      //	/**
      //	Converts a RGB image to grayscale. The source image is
      //	not modified
      //	@param source The source color image
      //	@param destination A reference to the new, filtered image
      //	 */
      void color2Grey (colimage& source, image& destination);

      //## Operation: calculateHue%3D994BC002A8
      //	/**
      //	Calculates the hue for one row in a RGB image. Note:
	  //	Although a reference to a whole image is passed
	  //	to store the calculated hues only the specified row
	  //	is actually converted! If the whole RGB image is to
	  //	be converted to hues this method must be called
	  //	seperately for each row of the image while always
	  //	passing the same source and destination
      //	@param source The source RGB image
      //	@param row The row in the source image for which the
      //	hues are to be calculated
      //	@param destination A reference to a greyscale image that is to
	  //    contain the calculated hues
	  //	@author adapted from Andrew Barry
      //	 */
      void calculateHue (colimage& source, int row, image& destination);

    // Additional Public Declarations
      //## begin ImageFilter%3D883FDA01E0.public preserve=yes
      //	/**
			//	 This value is returned by RGBtoHue if the passed
			//	 RGB triple has no hue
			//	 @see RGBtoHue
      //	 */
			static const BYTE NO_HUE;
      //## end ImageFilter%3D883FDA01E0.public

  protected:
    // Additional Protected Declarations
      //## begin ImageFilter%3D883FDA01E0.protected preserve=yes
      //## end ImageFilter%3D883FDA01E0.protected

  private:
    // Additional Private Declarations
      //## begin ImageFilter%3D883FDA01E0.private preserve=yes
      //	/**
      //	Calculates the hue for an RGB triple
      //	@param r Red value
      //	@param g Green value
			//	@param b Blue value
			//	@see NO_HUE
      //	@return The calculated hue (scaled to 0..252. The value 255 is used for no hue)
			//	@author Thomas Braunl
      //	 */
			BYTE RGBtoHue(BYTE r, BYTE g, BYTE b);
      //## end ImageFilter%3D883FDA01E0.private

  private: //## implementation
    // Additional Implementation Declarations
      //## begin ImageFilter%3D883FDA01E0.implementation preserve=yes
      //## end ImageFilter%3D883FDA01E0.implementation

};

//## begin ImageFilter%3D883FDA01E0.postscript preserve=yes
//## end ImageFilter%3D883FDA01E0.postscript

// Class ImageFilter

//## begin module%3D883FDA01E0.epilog preserve=yes
//## end module%3D883FDA01E0.epilog


#endif
