/// @file wrappers.hh
/// @author Stefan Schmitt <sschmitt@ee.uwa.edu.au>
/// @version 1.0
/// @date 2003-07
/// 
/// Declares ugly but working wrappers for attaching member functions to the
/// TPU.

#ifndef WRAPPERS_HH
#define WRAPPERS_HH

#include "mind/mind.hh"
#include "base/base.hh"
#include "behavior/behavior.hh"

namespace EyeMind {

#if (MAX_IRQ != 16 )
# error MAX_IRQ changed. You have to adapt the wrapper classes.
#endif


/// Wrapper for the Updatable::Update() member function.
class UpdatableFunctionWrapper
{
private:
	/// Instances to be upated.
	static Updatable* instances[MAX_IRQ];

	/// Counts created wrappers.
	static unsigned count;

#define FUNCTION(No) \
static void Function##No(){ instances[No]->Update(); }

	// MAX_IRQ functions.
	FUNCTION(0)
	FUNCTION(1)
	FUNCTION(2)
	FUNCTION(3)
	FUNCTION(4)
	FUNCTION(5)
	FUNCTION(6)
	FUNCTION(7)
	FUNCTION(8)
	FUNCTION(9)
	FUNCTION(10)
	FUNCTION(11)
	FUNCTION(12)
	FUNCTION(13)
	FUNCTION(14)
	FUNCTION(15)

#undef FUNCTION

	/// Unconstructible.
	UpdatableFunctionWrapper();

public:
	/// Returns a fresh wrapper for an Updatable.
	static void (*For(Updatable& u))();

	// try this:
	// echo "declare For as function (u as pointer to struct Updatable) 
	// returning pointer to function returning void;" | cundecl 
};



/// Wrapper for the Behavior::Excite() member function.
class BehaviorFunctionWrapper
{
private:
	/// Instances to be excited.
	static Behavior* instances[MAX_IRQ];

	/// Counts created wrappers.
	static unsigned count;

#define FUNCTION(No) \
static void Function##No(){ instances[No]->Excite(ROOT_DEFAULT_EXCITE); }

	// MAX_IRQ functions.
	FUNCTION(0)
	FUNCTION(1)
	FUNCTION(2)
	FUNCTION(3)
	FUNCTION(4)
	FUNCTION(5)
	FUNCTION(6)
	FUNCTION(7)
	FUNCTION(8)
	FUNCTION(9)
	FUNCTION(10)
	FUNCTION(11)
	FUNCTION(12)
	FUNCTION(13)
	FUNCTION(14)
	FUNCTION(15)

#undef FUNCTION

	/// Unconstructible.
	BehaviorFunctionWrapper();

public:
	/// Returns a fresh wrapper for a Behavior.
	static void (*For(Behavior& b))();
};


}; // namespace EyeMind

#endif // WRAPPERS_HH

