/**
 * Defines types for data storage in HDT
 */

#ifndef  EYEBOT_BEHAVIOR_TYPES_H
#define  EYEBOT_BEHAVIOR_TYPES_H

typedef struct
{
	int threshold;
} behavior_t;

typedef struct
{
	float radius;
	float width;
} twowheeldrive_bt;

typedef struct
{
	int limit_lo;
	int limit_hi;
	float Kp;
	float reset_time;
	float rate_time;
} vwdrive_bt;


typedef struct
{
	int hue;
	int threshold;
	int intensity_lo;
	int intensity_hi;
	int K_far;
	int intensity_thresh;
	int req_matches;
} findball_bt;


typedef struct
{
	float dband_compass;
	float Kw;
	float dband_psd;
	float left_bias;
	float right_bias;
	float v_fast;
	float v_slow;
	float v_turn;
	float w_slow;
	float max_turn_rate;
	int compass_offset;
	int internal_threshold;
} trackheading_bt;

typedef struct
{
	int time_limit;
	float dband;
} motorcontrol_bt;

typedef struct
{
	float Kp;
	float dband;
	float threshold_close_range; // (r,phi) where ball is 'close' to robot
	float threshold_close_phi;  // degrees
	int grace_period;
} turnhead_bt;

typedef struct
{
	float Kr; 
	float Kq;
	float dband_phi;
	float speed_close;
	float Kq_close;
	float Kq_close_hi;
	float w_slow;
	float close_threshold;
} turncommand_bt;

typedef struct
{
	int ticks_per_revolution;
	float timebase;
} dcmotor_bt;

typedef struct {
	float dband;
	float K;
	float left_bias;
	float right_bias;
	float max_turn_rate;
	float v_turning;
	float v_strike;
} centre_bt;

typedef struct
{
	unsigned d_side_avoid;
	unsigned d_front_close;
	unsigned d_back_close;
	float w_avoid_high;
	float w_avoid_low;
	float v_avoid_high;
	float v_avoid_low;
	int grace;
} avoid_bt;

typedef struct
{
	float gain;
	unsigned delay;
} stall_bt;

typedef struct
{
	float v;
	float w;
	float period;
} wander_bt;

typedef struct
{
	int exhaust_period;
	int start_period;
	float reacquire_v;
	float reacquire_w;
} reacquire_bt;

typedef struct
{
	float v;
	float w;
} motion_bt;

typedef struct
{
	char ref[8];
	int val;
} dictionary_entry_t;

typedef struct
{
	int length;
	dictionary_entry_t data[2];
} dictionary_t;

typedef struct
{
	int ref;
	int val;
} index_entry_t;

typedef struct
{
	int length;
	index_entry_t data[3];
} index_t;

typedef struct
{
	float dband_v;
	float dband_w;
	float Kv;
	float Kw;
	float left_bias;
	float right_bias;
	float max_speed;
	float max_rate_of_turn;
	int min_rear_distance;
	int max_rear_distance;
	int reset_rear_distance;
	int compass_offset;
	int second_offset;
} centregoalie_bt;

typedef struct
{
	float Kp_turn;
	float Kp_tilt;				// proportional gains
	float Kp_drive;
	float dband_turn;			//deadband regions
	float dband_tilt;
	float max_speed;
	float range_modifier;
	int compass_offset;
	int compass_dband;
	float Kw;
	float max_rate_of_turn;
} head2dof_bt;

typedef struct
{
	float fire_range;
} kickball_bt;

typedef struct
{
	int speed_x;
	int speed_y;
	int look_far;
	int look_close;
} headsearch_bt;

typedef struct
{
	int role;
	int kick;
} player_t;


#define B_TWOWHEELDRIVE 		100
#define B_VWDRIVE			200
#define B_FINDBALL			300

#define B_TRACKHEADING			400
#define B_ATTACK			410
#define B_DEFEND			420
#define B_ATTACKBALL			430

#define B_MOTORCONTROL			500
#define B_TURNHEAD			600
#define B_TURNCOMMAND			700
#define B_DCMOTOR			800
#define B_CENTRE			900
#define B_AVOID				1000
#define B_WANDER			1100
#define B_REACQUIRE			1200
#define B_OBEYCOACH			1300
#define B_MOTION			1400
#define B_STALL				1500
#define B_CENTREGOALIE		1600
#define B_HEAD2DOF			1700
#define B_KICKBALL			1800
#define B_HEADSEARCH			1900

#define B_MOTION_STOP			1410
#define B_MOTION_DRIVE_STRAIGHT		1411
#define B_MOTION_TURN_RIGHT_WIDE	1412
#define B_MOTION_TURN_RIGHT		1413
#define B_MOTION_TURN_LEFT_WIDE		1414
#define B_MOTION_TURN_LEFT		1415
#define B_MOTION_BACKUP			1416
#define B_MOTION_BACKUP_LEFT		1417
#define B_MOTION_BACKUP_RIGHT		1418
#define B_MOTION_KICKOFF		1420


#endif //EYEBOT_BEHAVIOR_TYPES_H
