/* ----------------------------------------------------------------- */
/* 'ZDVClass.h'										    */
/* Denavit- Hartenberg- Header- File						    */
/* 													    */
/* 	last modified 07/04/2003								    */
/* 	see ZDVClass.cc for implementations					    */
/* 													    */
/* 													    */
/* 													    */
/* 													    */
/* 	(C) Jochen Zimmermann								    */
/* ----------------------------------------------------------------- */

//avoid redefinition during static binding
#ifndef ZDVCLASS
#define ZDVCLASS

#include "ZHeaders.h"
/* needed headers, included via ZHeaders.h
#include "eyebot.h" 
#include "ZInfraRed.h"
#include "ZServo.h"
#include "ZAlgebraClass.h"
*/

class DenavitHartenberg : public LinearAlgebra
{	
    public:

	DenavitHartenberg();
	/*standard constructor for initialisations*/

	DenavitHartenberg(double *matrix, const int * const servopos, bool docalc=true, bool left=true);
	/*constructor with initialisation-data*/

	void	GetDVMatrix(double *matrix, int whichservo=9);
	/*returns new calculated DV-Matrix in buffer assigned by matrix, 
	determines which matrix to calculate by whichservo*/

	DenavitHartenberg& 	Calc		 (int whichservo=9);
	/*forces the instance to recalculate the matrix assigned by whichservo
	and returns a reference to itself*/

	DenavitHartenberg& 	operator = (const LinearAlgebra& tocopy);
	/*copy data from LinearAlgebra-object to calling instance, returns a 
	reference to itself*/


    private:
	bool   CalcMatrixFoot 	(bool left=true);
	/*assembles the matrix which transforms from one foot to hip-centre*/

	bool   CalcMatrixShank	(bool left=true);
	/*assembles the matrix which transforms from one shank to hip-centre*/

	bool   CalcMatrixThigh	(bool left=true);
	/*assembles the matrix which transforms from one thigh to hip-centre*/

	bool   CalcMatrixFootInv (bool left=true);
	/*assembles the matrix which transforms from hip-centre to one foot*/

	bool   CalcMatrixShankInv(bool left=true);
	/*assembles the matrix which transforms from hip-centre to one shank*/

	bool   CalcMatrixThighInv(bool left=true);
	/*assembles the matrix which transforms from hip-centre to one thigh*/

	bool   CalcTrigoTable	(int  whichservo=9);
	/*calculates the look-up table for matrix-assemby, depending on actual 
	servo-positions and on chosen link*/
	
    double ServoSin		(int  servopos);
    /*calculates sine directly out of given servo position*/

    double ServoCos		(int  servopos);
    /*calculates sine directly out of given servo position*/

	double trigotable[10];
	/*buffer for look-up table*/

	int    servoposition[NUMBEROFSERVOS];
	/*local storage of servopositions, retrieved from ServoClass*/

	static const float sinlookup[640];
	/*static look-up table for ServoSine-calculation*/
};

#endif

