/*
| -----------------------------------------------------------------------------
| Filename: hdtPendulum.c
|
| Author:       Thomas Braunl   (braunl@ee.uwa.edu.au)
|               Klaus Schmitt   (kschmitt@informatik.uni-kl.de)
|               Thomas Lampart  (lamparts@autolife.informatik.uni-stuttgart.de)
| Description:
| -------
| HDT data for BallyBot
| Braunl, 2004
| -----------------------------------------------------------------------------
*/

#define VERSION 1.1           /* User specific version nr. for information */
#define NAME "BallyBot"       /* Unique name of the platform max. 10 chars, just info */
#define ID  3                 /* Unique platform id (int), just for inform. */

#include "hdt.h"
#include "hdt_sem.h"

/* The HDT structure */
/*-------------------*/
int     magic = 123456789;
extern HDT_entry_type HDT[];
HDT_entry_type  *hdtbase = &HDT[0];

#include "types.h"
#include "const.h"
#include "rs232.h"
#include "cam.h"
#include "librobi/librobi.h"

BYTE motconv0[101]= { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,15,16,17,18,19,
                     20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,
                     40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,
                     60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,
                     80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,
                     100};

/* DC motors */
motor_type motor0 = {2,  1, TIMER1, 8191, (void*)OutBase, 3, 2, (BYTE*)&motconv0};
motor_type motor1 = {2,  0, TIMER1, 8191, (void*)OutBase, 0, 1, (BYTE*)&motconv0};
quad_type decoder0 = {0, 2, 3, MOTOR_LEFT,  3078, 2.0}; /* diameter 55.6 mm */
quad_type decoder1 = {0, 5, 4, MOTOR_RIGHT, 3078, 2.0};
vw_type drive = {0, DIFFERENTIAL_DRIVE, {QUAD_LEFT, QUAD_RIGHT, 0.1285}};
/* 122 mm inside 135 mm outside */

/* EyeBot SUMMARY */
info_type roboinfo  = {0,PLATFORM,SER115200,RTSCTS,SERIAL1,0,0,AUTOBRIGHTNESS,BATTERY_ON,40,VERSION,NAME,ID};

/* waitstates = 0..13, Fast Termination = 14, External = 15 */
/* Version, ROM, RAM, LCD, IO, Parallel+Serial2/3 */
/* 16MHz - 20Mhz */
/* waitstate_type waitstates = {0,3,0,1,0,2}; */
/* 21MHz - 41Mhz */
waitstate_type waitstates = {0,3,1,2,1,2};

/* this is a test HDT structure which contains ALL EyeBot hardware devices */

HDT_entry_type HDT[] =
{
    {MOTOR,MOTOR_RIGHT,"RIGHT",(void *)&motor0},
    {MOTOR,MOTOR_LEFT,"LEFT",(void *)&motor1},
    {QUAD, QUAD_RIGHT,"RIGHT",(void *)&decoder1},
    {QUAD, QUAD_LEFT,"LEFT",(void *)&decoder0},
    {VW,VW,"Drive",(void *)&drive},

    {WAIT,WAIT,"WAIT",(void *)&waitstates},
    {INFO,INFO,"INFO",(void *)&roboinfo},

    {END_OF_HDT,UNKNOWN_SEMANTICS,"END",(void *)0}
};

