	.include "tpuregex.i"

	| will be set to 1 by the interrupt function if new data is available
	.globl NewData13
NewData13:	.DS 4	


| initialization routine. Will enable ppwa function for channel 13 and enable interrupts.	
	.globl	tpuinit
tpuinit:
	move.l	#INT13,	0x174		| store starting address of interrupt
								| routine for channel 13

	or.w	#0x2000, cier		| enable interrupts for channel 13 
								| set cier to xx 1x xx xx xx xx xx xx

	or.w	#0x00f0, cfsr0		| select ppwa function for channel 11 (set cfsr0 to xx fx)

	and.w	#0xf3ff, hsqr0		| 24-bit high time 
	or.w	#0x0800, hsqr0		| set hsqr0 to xx xx 10 xx  xx xx xx xx
	
	| do i need to init all parameters?		
	move.w	#0x0007, ch13par0	| detect rising edge, no output, no links
	move.w	#0x0100, ch13par1	| maxcount - 1 period
	move.w	#0xff00, ch13par4	| set ACCUM_RATE to 0xFF (only final results needed)

	and.w	#0xf3ff, hsrr0		| request service to initialize channel 13
	or.w	#0x0800, hsrr0		| set hsrr0 to xx xx 10 xx  xx xx xx xx
								
	and.w	#0xf3ff, cpr0		| assign middle priority to channel 13
	or.w	#0x0800, cpr0		| set cpr1 to xx xx 10 xx  xx xx xx xx
wait:
	| wait until initialization complete 
	| hsrr0 bits 10, 11 (for channel 13) 
	| will be reset to zero if init complete.
	
	move.w	hsrr0,	d0			| get hsrr0
	andi.w	#0x0c00, d0			| look at interesting bits only
	bne	wait					| continue if these are zero
	
	| no data available
	move.l  #0x00000000, NewData13
	rts

| interrupt functions

INT13:
	move.l  #0x00000001, NewData13 | new data arrived

	and.w	#0xdfff	, cier		| no further new data notification (interrupt 13) until data is read

	andi.w	#0xdfff, cisr		| channel 13 interrupt not asserted
	rte


	
| read the values if there are values available
| int tpuread13()
	.globl	tpuread13			| channel 13
tpuread13:  
	cmpi.l  #0x01, NewData13		
	beq	readok13				| read data if new data available

	move.l  #0xffffffff, d0			| else return -1
	rts
readok13:	
	clr.l	d0						| new data available:
	move.w	ch13par5, d0			| return value
	move.l  #0x00,	NewData13		| data read
	or.w	#0x2000, cier			| notify on new data
	rts				

	.globl	tpurelease		
tpurelease:	
	andi.w	#0xf3ff, cpr0			| stop channel 13
	andi.w	#0xdfff, cisr			| channel 11 interrupt not asserted
	andi.w	#0xdfff, cier			| disable further irq
	move.l  #0x00000000, NewData13	| no more data
	rts	
