/// @file standard_behaviors.cc

#include "behavior/standard_behaviors.hh"

namespace EyeMind {

/**
 * Shutdown
 */

int Shutdown::Execute()
{
	Mind::ActiveId()->Active(false);
	return 0;
}


/**
 * BehaviorSwitch
 */

BehaviorSwitch::BehaviorSwitch()
{
	select=0;
}

void BehaviorSwitch::Excite(int signal)
{
	SignalLink *sl;
	IntLink *l = reinterpret_cast<IntLink*>(FindMaxNonGenericInputSignal());
	int s = signal;

	if(l!=NULL)
	{
		select = l->Int();
		s = l->Signal();
	}

	sl = outlinks[select];
	if(sl!=NULL)
	{
		sl->Signal(s);  //JB: Pass on the same signal as on the
		// int-link we are selecting. (Otherwise, if the BehaviorSwitch is
		// a attatched as a root behavior, it will pass on a '1' when
		// excited by the root, and some other value when excited by
		// a change on an input-link (which is inconsistant).
		DecayInputSignals();
	}
}


int BehaviorSwitch::Execute()
{
	return 0;  // return zero so outputs are not excited
}


BehaviorSwitch& operator>>(IntLink& l, BehaviorSwitch& o)
{
	SignalLinkOutputToBehavior(l,o);
	return o;
}


IntLink& operator<<(BehaviorSwitch& n, IntLink& i)
{
	BehaviorInputToSignalLink(n,i);
	return i;
}


/**
 * BehaviorRoot
 */
 
BehaviorRoot::BehaviorRoot() : Behavior()
{
	Threshold(-1);	// set to -1 so sum of zero will excite
}

int BehaviorRoot::Execute()
{
	return 1;	// return a 1 if excited
}

}; // namespace EyeMind

