/* Wireless Demo - Program for PC */
/* Thomas Braunl, Nov. 2000              */

#include "remote.h"
#include "eyebot.h"

int main()
{ BYTE myId, nextId, fromId;
  BYTE mes[20]; /* message buffer */
  int  len, err;
  RadioIOParameters radioParams;

  printf("Wireless Eye2PC\n");
  printf("---------------\n");

  RADIOGetIoctl(&radioParams);
    /* now set parameter to desired values */
    radioParams.speed = SER38400;
    radioParams.interface = SERIAL3; /* COM 3 */
  RADIOSetIoctl(radioParams);

  printf("Radio");
  err = RADIOInit();
  if (err) { printf("Error Radio Init\n"); return 1; }
    else printf("Init\n");

  /* PC (ID o) will send to eobot 1, but has to wait first */
  nextId = 1;

  while (1)
  { if (RADIOCheck())  /* check whether message is waiting */
    { RADIORecv(&fromId, &len, mes);  /* wait for next message */
      printf("Recv %d-%d: %3d\a\n", fromId, len, mes[0]);
      mes[0]++;              /* increment number and send again */
      err = RADIOSend(nextId, 1, mes);
      if (err) { printf("Error Send\n"); return 1; }
    }
  }
  RADIOTerm();
  return 0;
}

