/***************************************************************************/
/* sensors.h                                                               */
/* Collection of function to initialize and read sensor values             */
/* Author: Rich Chi Ooi                                                    */
/* Version: 1.2                                                            */
/* Date:06.06.2003                                                         */ 
/* -------------------------------                                         */
/* Compilation  procedure:                                                 */
/*       Linux                                                             */
/*      gcc68 -c  XXXXXX.c (to create object file)                         */
/*      gcc68 -o  XXXXXX.hex XXXXXX.o ppwa.o                               */
/***************************************************************************/
/* In this version:                                                        */
/***************************************************************************/

#include <stdlib.h>
#include "eyebot.h"

#ifndef sensors_h
#define sensors_h
/*
 * Reading from A/D port to get raw sensor data
 * For use with analog gyro
 */
int analogSensor (int x);  /* return the value of the analog input Number x */

/*
 *Initialize the TPU for reading digital sensors
 *Servo 5(TPU 6) accreadX()
 *Servo 6(TPU 7) accreadY()
 */
void tpuInit();

/*
 *Initialize the gyro
 */
void gyroInit(ServoHandle gyroName);
 
/*
 *Initialize the inclinometer
 */
void inclinoInit();

/*
 * Reads TPU7 and convert inclinometer value to angle
 */
float incAngle();

/*
 *Returns the inclino raw value
 */
int incRaw();

/*
 *Returns the gyro raw value
 */
int gyroRaw();

float gyVelocity();

void gyroMiddle();

#endif
 	
