/* BALLYBOT Remote                  */
/* Drives balancing robot with      */
/* wireless infrared remote         */
/* -------------------------------- */
/* Thomas Braunl           UWA 2001 */

#define STD_V 		1.0

#include "eyebot.h"
#include "IRnokia.h"
#include <math.h>
#include <stdio.h>

int main(void)
{
  int terminated = 0;
  int code       = 0;
  meterPerSec v  = 0.0;
  VWHandle vw;

  LCDPutString("BALLY Rem.\n");
  vw = VWInit(VW_DRIVE,1); /* init v-omega interface */
  if(vw == 0)
    {
      LCDPutString("VWInit Error!\n\a");
      OSWait(200); return 0;
    }
  VWStartControl(vw,7,0.3,7,0.1);
  LCDPrintf("IRTVInit: %d\n", IRTVInit(SPACE_CODE,15,0,0x03ff,SLOPPY_MODE,1,10));
  while (!terminated)
  	{ switch (code = IRTVRead())
		{ case 0: 
		   break;
		  case RC_0: 
		   break;
		  case RC_1: 
		   break;
		  case RC_2:
		  	LCDPrintf("forward\n");
		  	v = STD_V;
		   break;
		  case RC_3: 
		   break;
	  	  case RC_4: 
		   break;
	  	  case RC_5: 
	  		LCDPrintf("stop\n");
	  		v = 0;
	  	   break;
	  	  case RC_6: 
		   break;
	  	  case RC_7: 
		   break;
                  case RC_8: 
		  	LCDPrintf("back\n");
		  	v = -STD_V;
		   break;
	  	  case RC_9: 
		   break;
	  	  case RC_FF: 
		   break;			
	  	  case RC_RW: 
		   break;			
	  	  case RC_PLAY: 
		   break;
	  	  case RC_STOP: 
		   break;
	  	  case RC_OK: 
		   break;			
	  	  case RC_STANDBY: 
		   break;
	  	default:
	  		LCDPrintf("unhandled: %4x\n", code);			
		}
		VWSetSpeed(vw, v, 0.0);
	}
	VWRelease(vw);
	IRTVTerm();
  return 0;
}

