///@file pc_behaviors.hh
///@author Josh Petitt
///@date 11 April 2002
///
/// Defines some simple behaviors for the pc terminal


#ifdef WIN32
#ifndef PC_BEHAVIORS_HH
#define PC_BEHAVIORS_HH


#include "behavior/behavior.hh"
#include "behavior/stdc_linktypes.hh"
#include "behavior/stdcc_linktypes.hh"
#include "input/pc_sensors.hh"
#include "output/pc_actors.hh"


///A Behavior for feeling key input
///
///@arg SignalLink
///@arg StringLink
class KeyboardFeel:public Behavior
{
private: 
    Keyboard &keyboard;

protected:
	int Execute();
	void Feed(SignalLink &l);

public:
	KeyboardFeel();
	
};

CharLink& operator>>(KeyboardFeel& n, CharLink& o);



///A Behavior for printing strings to the screen
///
///@arg StringLink
///@arg None
class TerminalShow:public Behavior
{
private:
	Terminal &terminal;

protected:
  	int Execute();

public:
    TerminalShow();
};

TerminalShow& operator>>(StringLink& l, TerminalShow& o);
    

#endif //PC_BEHAVIORS_HH
#endif //WIN32
